/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.freemarker;

import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Map;
import org.molgenis.data.DataConverter;
import org.molgenis.data.DataService;
import org.molgenis.framework.ui.MolgenisPlugin;
import org.molgenis.framework.ui.MolgenisPluginRegistry;

public class DataExplorerHyperlinkDirective
implements TemplateDirectiveModel {
    private final MolgenisPluginRegistry molgenisPluginRegistry;
    private final DataService dataService;

    public DataExplorerHyperlinkDirective(MolgenisPluginRegistry molgenisPluginRegistry, DataService dataService) {
        this.molgenisPluginRegistry = molgenisPluginRegistry;
        this.dataService = dataService;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (!params.containsKey("entityName")) {
            throw new TemplateModelException("Missing 'entityName' parameter");
        }
        String dataset = DataConverter.toString(params.get("entityName"));
        MolgenisPlugin dataexplorer = this.molgenisPluginRegistry.getPlugin("dataexplorer");
        Writer w = env.getOut();
        if (this.dataService.hasRepository(dataset) && dataexplorer != null) {
            String cssClass = DataConverter.toString(params.get("class"));
            String dataexplorerPageUri = String.format("%s?entity=%s", dataexplorer.getFullUri(), URLEncoder.encode(dataset, "UTF-8"));
            w.write("<a href='");
            w.write(dataexplorerPageUri);
            w.write("' ");
            if (cssClass != null) {
                w.write("class='" + cssClass + "' ");
            }
            w.write(">");
            body.render(w);
            w.write("</a>");
        } else if (params.containsKey("alternativeText")) {
            w.write(DataConverter.toString(params.get("alternativeText")));
        }
    }
}

