/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.settings;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.settings.DefaultSettingsEntity;
import org.molgenis.data.settings.DefaultSettingsEntityType;
import org.springframework.stereotype.Component;

@Component
public class DataExplorerSettings
extends DefaultSettingsEntity {
    private static final long serialVersionUID = 1L;
    private static final String ID = "dataexplorer";

    public DataExplorerSettings() {
        super(ID);
    }

    public boolean getModAggregates() {
        Boolean value = this.getBoolean("mod_aggregates");
        return value != null ? value : false;
    }

    public void setModAggregates(boolean modAggregates) {
        this.set("mod_aggregates", modAggregates);
    }

    public boolean getModAnnotators() {
        Boolean value = this.getBoolean("mod_annotators");
        return value != null ? value : false;
    }

    public void setModAnnotators(boolean modAnnotators) {
        this.set("mod_annotators", modAnnotators);
    }

    public boolean getModCharts() {
        Boolean value = this.getBoolean("mod_charts");
        return value != null ? value : false;
    }

    public void setModCharts(boolean modCharts) {
        this.set("mod_charts", modCharts);
    }

    public boolean getModData() {
        Boolean value = this.getBoolean("mod_data");
        return value != null ? value : false;
    }

    public void setModData(boolean modData) {
        this.set("mod_data", modData);
    }

    public boolean getModReports() {
        Boolean value = this.getBoolean("mod_reports");
        return value != null ? value : false;
    }

    public void setModReports(boolean modReports) {
        this.set("mod_reports", modReports);
    }

    public Boolean getGalaxyExport() {
        return this.getBoolean("data_galaxy_export");
    }

    public void setGalaxyExport(boolean galaxyExport) {
        this.set("data_galaxy_export", galaxyExport);
    }

    public Map<String, String> getAggregatesDistinctOverrides() {
        String distinctAttrOverridesStr = this.getString("agg_distinct_overrides");
        return (Map)new Gson().fromJson(distinctAttrOverridesStr, new TypeToken<Map<String, String>>(){}.getType());
    }

    public void setAggregatesDistinctOverrides(Map<String, String> aggregatesDistinctOverrides) {
        String value = aggregatesDistinctOverrides != null ? new Gson().toJson(aggregatesDistinctOverrides) : null;
        this.set("agg_distinct_overrides", value);
    }

    public boolean getSearchbox() {
        Boolean value = this.getBoolean("searchbox");
        return value != null ? value : false;
    }

    public void setSearchbox(boolean searchbox) {
        this.set("searchbox", searchbox);
    }

    public boolean getItemSelection() {
        Boolean value = this.getBoolean("item_select_panel");
        return value != null ? value : false;
    }

    public void setItemSelection(boolean itemSelection) {
        this.set("item_select_panel", itemSelection);
    }

    public boolean getLaunchWizard() {
        Boolean value = this.getBoolean("launch_wizard");
        return value != null ? value : false;
    }

    public void setLaunchWizard(boolean launchWizard) {
        this.set("launch_wizard", launchWizard);
    }

    public int getHeaderAbbreviate() {
        Integer value = this.getInt("header_abbreviate");
        return value != null ? value : -1;
    }

    public void setHeaderAbbreviate(int headerAbbreviate) {
        this.set("header_abbreviate", headerAbbreviate);
    }

    public URI getGalaxyUrl() {
        String galaxyUrl = this.getString("data_galaxy_url");
        if (galaxyUrl != null) {
            try {
                return new URI(galaxyUrl);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setGalaxyUrl(URI galaxyUrl) {
        this.set("data_galaxy_url", galaxyUrl.toString());
    }

    public boolean getGenomeBrowser() {
        Boolean value = this.getBoolean("data_genome_browser");
        return value != null ? value : false;
    }

    public void setGenomeBrowser(boolean genomeBrowser) {
        this.set("data_genome_browser", genomeBrowser);
    }

    public String getGenomeBrowserLocation() {
        return this.getString("gb_init_location");
    }

    public void setGenomeBrowserLocation(String genomeBrowserLocation) {
        this.set("gb_init_location", genomeBrowserLocation);
    }

    public String getGenomeBrowserCoordSystem() {
        return this.getString("gb_init_coord_system");
    }

    public void setGenomeBrowserCoordSystem(String genomeBrowserCoordSystem) {
        this.set("gb_init_coord_system", genomeBrowserCoordSystem);
    }

    public String getGenomeBrowserSources() {
        return this.getString("gb_init_sources");
    }

    public void setGenomeBrowserSources(String genomeBrowserSources) {
        this.set("gb_init_sources", genomeBrowserSources);
    }

    public String getGenomeBrowserLinks() {
        return this.getString("gb_init_browser_links");
    }

    public void setGenomeBrowserLinks(String genomeBrowserLinks) {
        this.set("gb_init_browser_links", genomeBrowserLinks);
    }

    public boolean getGenomeBrowserHighlightRegion() {
        Boolean value = this.getBoolean("gb_init_highlight_region");
        return value != null ? value : false;
    }

    public void setGenomeBrowserHighlightRegion(boolean genomeBrowserHighlightRegion) {
        this.set("gb_init_highlight_region", genomeBrowserHighlightRegion);
    }

    public boolean getAggregatesDistinctSelect() {
        Boolean value = this.getBoolean("agg_distinct");
        return value != null ? value : false;
    }

    public void setAggregatesDistinctSelect(boolean aggregatesDistinctSelect) {
        this.set("agg_distinct", aggregatesDistinctSelect);
    }

    public String getEntityReports() {
        return this.getString("reports_entities");
    }

    public String getEntityReport(String entityName) {
        Map<String, String> entityReports = this.getEntityReportsAsMap();
        return entityReports != null ? entityReports.get(entityName) : null;
    }

    public void setEntityReports(String entityReportsStr) {
        this.set("reports_entities", entityReportsStr);
    }

    private Map<String, String> getEntityReportsAsMap() {
        String entityReportsStr = this.getEntityReports();
        if (entityReportsStr != null) {
            LinkedHashMap<String, String> entityReports = new LinkedHashMap<String, String>();
            for (String entityReport : entityReportsStr.split(",")) {
                String[] tokens = entityReport.split(":");
                String entityName = tokens[0];
                String reportName = tokens[1];
                entityReports.put(entityName, reportName);
            }
            return entityReports;
        }
        return null;
    }

    @Component
    private static class Meta
    extends DefaultSettingsEntityType {
        public static final String GENERAL = "general_";
        public static final String GENERAL_SEARCHBOX = "searchbox";
        public static final String GENERAL_ITEM_SELECT_PANEL = "item_select_panel";
        public static final String GENERAL_LAUNCH_WIZARD = "launch_wizard";
        public static final String GENERAL_HEADER_ABBREVIATE = "header_abbreviate";
        private static final boolean DEFAULT_GENERAL_SEARCHBOX = true;
        private static final boolean DEFAULT_GENERAL_ITEM_SELECT_PANEL = true;
        private static final boolean DEFAULT_GENERAL_LAUNCH_WIZARD = false;
        private static final int DEFAULT_GENERAL_HEADER_ABBREVIATE = 180;
        public static final String MOD = "mods";
        public static final String MOD_AGGREGATES = "mod_aggregates";
        public static final String MOD_ANNOTATORS = "mod_annotators";
        public static final String MOD_CHARTS = "mod_charts";
        public static final String MOD_DATA = "mod_data";
        public static final String MOD_REPORTS = "mod_reports";
        private static final boolean DEFAULT_MOD_AGGREGATES = true;
        private static final boolean DEFAULT_MOD_ANNOTATORS = true;
        private static final boolean DEFAULT_MOD_CHARTS = true;
        private static final boolean DEFAULT_MOD_DATA = true;
        private static final boolean DEFAULT_MOD_REPORT = true;
        public static final String DATA = "data";
        public static final String DATA_GALAXY_EXPORT = "data_galaxy_export";
        public static final String DATA_GALAXY_URL = "data_galaxy_url";
        public static final String DATA_GALAXY_API_KEY = "data_galaxy_api_key";
        public static final String DATA_GENOME_BROWSER = "data_genome_browser";
        private static final boolean DEFAULT_DATA_GALAXY_EXPORT = true;
        private static final boolean DEFAULT_DATA_GENOME_BROWSER = true;
        public static final String GENOMEBROWSER = "genomebrowser";
        public static final String GENOMEBROWSER_INIT = "gb_init";
        public static final String GENOMEBROWSER_INIT_BROWSER_LINKS = "gb_init_browser_links";
        public static final String GENOMEBROWSER_INIT_COORD_SYSTEM = "gb_init_coord_system";
        public static final String GENOMEBROWSER_INIT_LOCATION = "gb_init_location";
        public static final String GENOMEBROWSER_INIT_SOURCES = "gb_init_sources";
        public static final String GENOMEBROWSER_INIT_HIGHLIGHT_REGION = "gb_init_highlight_region";
        private static final String DEFAULT_GENOMEBROWSER_INIT_BROWSER_LINKS = "{Ensembl: 'http://www.ensembl.org/Homo_sapiens/Location/View?r=${chr}:${start}-${end}',UCSC: 'http://genome.ucsc.edu/cgi-bin/hgTracks?db=hg19&position=chr${chr}:${start}-${end}',Sequence: 'http://www.derkholm.net:8080/das/hg19comp/sequence?segment=${chr}:${start},${end}'}";
        private static final String DEFAULT_GENOMEBROWSER_INIT_COORD_SYSTEM = "{speciesName: 'Human',taxon: 9606,auth: 'GRCh',version: '37',ucscName: 'hg19'}";
        private static final String DEFAULT_GENOMEBROWSER_INIT_LOCATION = "chr:'1',viewStart:10000000,viewEnd:10100000,cookieKey:'human',nopersist:true";
        private static final String DEFAULT_GENOMEBROWSER_INIT_SOURCES = "[{name:'Genome',twoBitURI:'//www.biodalliance.org/datasets/hg19.2bit',tier_type: 'sequence'},{name: 'Genes',desc: 'Gene structures from GENCODE 19',bwgURI: '//www.biodalliance.org/datasets/gencode.bb',stylesheet_uri: '//www.biodalliance.org/stylesheets/gencode.xml',collapseSuperGroups: true,trixURI:'//www.biodalliance.org/datasets/geneIndex.ix'},{name: 'Repeats',desc: 'Repeat annotation from Ensembl 59',bwgURI: '//www.biodalliance.org/datasets/repeats.bb',stylesheet_uri: '//www.biodalliance.org/stylesheets/bb-repeats.xml'},{name: 'Conservation',desc: 'Conservation',bwgURI: '//www.biodalliance.org/datasets/phastCons46way.bw',noDownsample: true}]";
        private static final boolean DEFAULT_GENOMEBROWSER_INIT_HIGHLIGHT_REGION = false;
        public static final String AGGREGATES = "aggregates";
        public static final String AGGREGATES_DISTINCT_SELECT = "agg_distinct";
        public static final String AGGREGATES_DISTINCT_OVERRIDES = "agg_distinct_overrides";
        public static final String REPORTS = "reports";
        public static final String REPORTS_ENTITIES = "reports_entities";
        private static final boolean DEFAULT_AGGREGATES_DISTINCT_SELECT = true;

        public Meta() {
            super(DataExplorerSettings.ID);
        }

        public void init() {
            super.init();
            this.setLabel("Data explorer settings");
            this.setDescription("Settings for the data explorer plugin.");
            this.addGeneralSettings();
            this.addModulesSettings();
        }

        private void addGeneralSettings() {
            Attribute generalAttr = this.addAttribute(GENERAL, new EntityType.AttributeRole[0]).setDataType(AttributeType.COMPOUND).setLabel("General");
            this.addAttribute(GENERAL_SEARCHBOX, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Show search box");
            this.addAttribute(GENERAL_ITEM_SELECT_PANEL, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Show data item selection");
            this.addAttribute(GENERAL_LAUNCH_WIZARD, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(false)).setLabel("Launch data item filter wizard");
            this.addAttribute(GENERAL_HEADER_ABBREVIATE, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.INT).setNillable(false).setDefaultValue(String.valueOf(180)).setLabel("Entity description abbreviation length");
        }

        private void addModulesSettings() {
            Attribute modAttr = this.addAttribute(MOD, new EntityType.AttributeRole[0]).setDataType(AttributeType.COMPOUND).setLabel("Modules");
            this.addAttribute(MOD_AGGREGATES, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Aggregates");
            this.createModAggregatesSettings(modAttr);
            this.addAttribute(MOD_ANNOTATORS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Annotators");
            this.addAttribute(MOD_CHARTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Charts");
            this.addAttribute(MOD_DATA, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Data");
            this.createModDataSettings(modAttr);
            this.addAttribute(MOD_REPORTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Reports");
            this.createModReportSettings(modAttr);
        }

        private void createModDataSettings(Attribute modAttr) {
            Attribute dataAttr = this.addAttribute(DATA, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Data").setVisibleExpression("$('mod_data').eq(true).value()");
            this.addAttribute(DATA_GALAXY_EXPORT, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Galaxy export");
            this.addAttribute(DATA_GALAXY_URL, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.HYPERLINK).setNillable(true).setLabel("Galaxy URL").setVisibleExpression("$('data_galaxy_export').eq(true).value()");
            this.addAttribute(DATA_GALAXY_API_KEY, new EntityType.AttributeRole[0]).setParent(dataAttr).setNillable(true).setLabel("Galaxy API key").setVisibleExpression("$('data_galaxy_export').eq(true).value()");
            Attribute genomeBrowserAttr = this.addAttribute(GENOMEBROWSER, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.COMPOUND).setLabel("Genome Browser").setVisibleExpression("$('data_genome_browser').eq(true).value()");
            Attribute genomeBrowserInitAttr = this.addAttribute(GENOMEBROWSER_INIT, new EntityType.AttributeRole[0]).setParent(genomeBrowserAttr).setDataType(AttributeType.COMPOUND).setLabel("Initialization");
            this.addAttribute(GENOMEBROWSER_INIT_BROWSER_LINKS, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_BROWSER_LINKS).setLabel("Browser links");
            this.addAttribute(GENOMEBROWSER_INIT_COORD_SYSTEM, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_COORD_SYSTEM).setLabel("Coordinate system");
            this.addAttribute(GENOMEBROWSER_INIT_LOCATION, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_LOCATION).setLabel("Location");
            this.addAttribute(GENOMEBROWSER_INIT_SOURCES, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_SOURCES).setLabel("Sources");
            this.addAttribute(GENOMEBROWSER_INIT_HIGHLIGHT_REGION, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.BOOL).setDefaultValue(String.valueOf(false)).setLabel("Highlight region");
            this.addAttribute(DATA_GENOME_BROWSER, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Genome Browser");
        }

        private void createModAggregatesSettings(Attribute modAttr) {
            Attribute aggregatesAttr = this.addAttribute(AGGREGATES, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Aggregates").setVisibleExpression("$('mod_aggregates').eq(true).value()");
            this.addAttribute(AGGREGATES_DISTINCT_SELECT, new EntityType.AttributeRole[0]).setParent(aggregatesAttr).setNillable(false).setDataType(AttributeType.BOOL).setDefaultValue(String.valueOf(true)).setLabel("Distinct aggregates");
            this.addAttribute(AGGREGATES_DISTINCT_OVERRIDES, new EntityType.AttributeRole[0]).setParent(aggregatesAttr).setDataType(AttributeType.TEXT).setLabel("Distinct attribute overrides").setDescription("JSON object that maps entity names to attribute names").setVisibleExpression("$('agg_distinct').eq(true).value()");
        }

        private void createModReportSettings(Attribute modAttr) {
            Attribute reportsAttr = this.addAttribute(REPORTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Reports").setVisibleExpression("$('mod_reports').eq(true).value()");
            this.addAttribute(REPORTS_ENTITIES, new EntityType.AttributeRole[0]).setParent(reportsAttr).setNillable(true).setDataType(AttributeType.TEXT).setLabel("Reports").setDescription("Comma-seperated report strings (e.g. MyDataSet:myreport,OtherDataSet:otherreport). The report name refers to an existing FreemarkerTemplate entity or file with name view-<report>-entitiesreport.ftl (e.g. view-myreport-entitiesreport.ftl)");
        }
    }
}

