/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.download;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.AbstractWritable;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class DataExplorerDownloadHandler {
    private final DataService dataService;
    private final AttributeFactory attrMetaFactory;

    @Autowired
    public DataExplorerDownloadHandler(DataService dataService, AttributeFactory attrMetaFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToExcel(DataRequest dataRequest, OutputStream outputStream) throws IOException {
        ExcelWriter excelWriter = new ExcelWriter(outputStream, this.attrMetaFactory, ExcelWriter.FileFormat.XLSX);
        String entityTypeId = dataRequest.getEntityName();
        QueryImpl<Entity> query = dataRequest.getQuery();
        ExcelSheetWriter excelSheetWriter = null;
        try {
            EntityType entityType = this.dataService.getEntityType(entityTypeId);
            LinkedHashSet<String> attributeNames = new LinkedHashSet<String>(dataRequest.getAttributeNames());
            Iterable attributes = Iterables.filter((Iterable)entityType.getAtomicAttributes(), attribute -> attributeNames.contains(attribute.getName()));
            switch (dataRequest.getColNames()) {
                case ATTRIBUTE_LABELS: {
                    excelSheetWriter = excelWriter.createWritable(entityTypeId, attributes, AbstractWritable.AttributeWriteMode.ATTRIBUTE_LABELS);
                    break;
                }
                case ATTRIBUTE_NAMES: {
                    excelSheetWriter = excelWriter.createWritable(entityTypeId, attributes, AbstractWritable.AttributeWriteMode.ATTRIBUTE_NAMES);
                }
            }
            switch (dataRequest.getEntityValues()) {
                case ENTITY_IDS: {
                    excelSheetWriter.setEntityWriteMode(AbstractWritable.EntityWriteMode.ENTITY_IDS);
                    break;
                }
                case ENTITY_LABELS: {
                    excelSheetWriter.setEntityWriteMode(AbstractWritable.EntityWriteMode.ENTITY_LABELS);
                    break;
                }
            }
            excelSheetWriter.add(this.dataService.findAll(entityTypeId, query));
            excelSheetWriter.close();
        }
        finally {
            excelWriter.close();
        }
    }

    public void writeToCsv(DataRequest request, OutputStream outputStream, char separator) throws IOException {
        this.writeToCsv(request, outputStream, separator, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToCsv(DataRequest dataRequest, OutputStream outputStream, char separator, boolean noQuotes) throws IOException {
        CsvWriter csvWriter = new CsvWriter(outputStream, separator, noQuotes);
        switch (dataRequest.getEntityValues()) {
            case ENTITY_IDS: {
                csvWriter.setEntityWriteMode(AbstractWritable.EntityWriteMode.ENTITY_IDS);
                break;
            }
            case ENTITY_LABELS: {
                csvWriter.setEntityWriteMode(AbstractWritable.EntityWriteMode.ENTITY_LABELS);
                break;
            }
        }
        String entityTypeId = dataRequest.getEntityName();
        try {
            EntityType entityType = this.dataService.getEntityType(entityTypeId);
            HashSet<String> attributeNames = new HashSet<String>(dataRequest.getAttributeNames());
            Iterable attributes = Iterables.filter((Iterable)entityType.getAtomicAttributes(), attribute -> attributeNames.contains(attribute.getName()));
            switch (dataRequest.getColNames()) {
                case ATTRIBUTE_LABELS: {
                    csvWriter.writeAttributes(attributes);
                    break;
                }
                case ATTRIBUTE_NAMES: {
                    csvWriter.writeAttributeNames(Iterables.transform((Iterable)attributes, Attribute::getName));
                }
            }
            QueryImpl<Entity> query = dataRequest.getQuery();
            csvWriter.add(this.dataService.findAll(entityTypeId, query));
        }
        finally {
            csvWriter.close();
        }
    }
}

