/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.service;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.GenomicDataSettings;
import org.springframework.stereotype.Component;

@Component
public class GenomeBrowserService {
    private DataService dataService;
    private GenomicDataSettings genomicDataSettings;

    public GenomeBrowserService(DataService dataService, GenomicDataSettings genomicDataSettings) {
        this.dataService = Objects.requireNonNull(dataService);
        this.genomicDataSettings = Objects.requireNonNull(genomicDataSettings);
    }

    public Stream<EntityType> getGenomeBrowserEntities() {
        return this.dataService.getMeta().getEntityTypes().filter(entityType -> !entityType.isAbstract()).filter(this::isGenomeBrowserEntity);
    }

    private boolean isGenomeBrowserEntity(EntityType entityType) {
        Attribute attributeStartPosition = this.genomicDataSettings.getAttributeMetadataForAttributeNameArray("start", entityType);
        Attribute attributeChromosome = this.genomicDataSettings.getAttributeMetadataForAttributeNameArray("chromosome", entityType);
        return attributeStartPosition != null && attributeChromosome != null;
    }
}

