/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.web.AnnotationService;
import org.molgenis.data.annotation.web.meta.AnnotationJobExecution;
import org.molgenis.data.annotation.web.meta.AnnotationJobExecutionFactory;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.dataexplorer.controller.AnnotationJob;
import org.molgenis.dataexplorer.controller.AnnotationJobFactory;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/annotators"})
public class AnnotatorController {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotatorController.class);
    public static final String URI = "/annotators";
    private final DataService dataService;
    private final AnnotationService annotationService;
    private final PermissionService permissionService;
    private final UserAccountService userAccountService;
    private final AnnotationJobFactory annotationJobFactory;
    private final ExecutorService taskExecutor;
    private final AnnotationJobExecutionFactory annotationJobExecutionFactory;

    @Autowired
    public AnnotatorController(DataService dataService, AnnotationService annotationService, PermissionService permissionService, UserAccountService userAccountService, AnnotationJobFactory annotationJobFactory, ExecutorService taskExecutor, AnnotationJobExecutionFactory annotationJobExecutionFactory) {
        this.dataService = dataService;
        this.annotationService = annotationService;
        this.permissionService = permissionService;
        this.userAccountService = userAccountService;
        this.annotationJobFactory = annotationJobFactory;
        this.taskExecutor = taskExecutor;
        this.annotationJobExecutionFactory = annotationJobExecutionFactory;
    }

    @RequestMapping(value={"/get-available-annotators"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Map<String, Object>> getMapOfAvailableAnnotators(@RequestBody String dataSetName) {
        Map<String, Map<String, Object>> annotatorMap = this.setMapOfAnnotators(dataSetName);
        return annotatorMap;
    }

    @RequestMapping(value={"/annotate-data"}, method={RequestMethod.POST})
    @ResponseBody
    public String annotateData(HttpServletRequest request, @RequestParam(value="annotatorNames", required=false) String[] annotatorNames, @RequestParam(value="dataset-identifier") String entityTypeId) {
        Repository repository = this.dataService.getRepository(entityTypeId);
        if (annotatorNames != null && repository != null) {
            this.scheduleAnnotatorRun(repository.getEntityType().getId(), annotatorNames);
        }
        return entityTypeId;
    }

    public String scheduleAnnotatorRun(String entityTypeId, String[] annotatorNames) {
        AnnotationJobExecution annotationJobExecution = (AnnotationJobExecution)this.annotationJobExecutionFactory.create();
        annotationJobExecution.setUser(this.userAccountService.getCurrentUser());
        annotationJobExecution.setTargetName(entityTypeId);
        annotationJobExecution.setAnnotators(String.join((CharSequence)",", annotatorNames));
        annotationJobExecution.setResultUrl("/menu/main/dataexplorer?entity=" + entityTypeId);
        AnnotationJob job = this.annotationJobFactory.createJob(annotationJobExecution);
        this.taskExecutor.submit(job);
        return annotationJobExecution.getIdentifier();
    }

    private Map<String, Map<String, Object>> setMapOfAnnotators(String dataSetName) {
        HashMap<String, Map<String, Object>> mapOfAnnotators = new HashMap<String, Map<String, Object>>();
        if (dataSetName != null) {
            EntityType entityType = this.dataService.getEntityType(dataSetName);
            for (RepositoryAnnotator annotator : this.annotationService.getAllAnnotators()) {
                List<Attribute> outputAttrs = annotator.getOutputAttributes();
                outputAttrs = this.getAtomicAttributesFromList(outputAttrs);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("description", annotator.getDescription());
                map.put("canAnnotate", annotator.canAnnotate(entityType));
                map.put("inputAttributes", this.createAttrsResponse(annotator.getRequiredAttributes()));
                map.put("inputAttributeTypes", this.toMap(annotator.getRequiredAttributes()));
                map.put("outputAttributes", this.createAttrsResponse(outputAttrs));
                map.put("outputAttributeTypes", this.toMap(annotator.getOutputAttributes()));
                String settingsEntityName = "sys_set_" + annotator.getInfo().getCode();
                map.put("showSettingsButton", this.permissionService.hasPermissionOnEntityType(settingsEntityName, Permission.WRITE));
                mapOfAnnotators.put(annotator.getSimpleName(), map);
            }
        }
        return mapOfAnnotators;
    }

    private List<Map<String, Object>> createAttrsResponse(List<Attribute> inputMetaData) {
        return inputMetaData.stream().map(attr -> {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("name", attr.getName());
            attrMap.put("description", attr.getDescription());
            return attrMap;
        }).collect(Collectors.toList());
    }

    private List<Attribute> getAtomicAttributesFromList(List<Attribute> outputAttrs) {
        if (outputAttrs.size() == 1 && outputAttrs.get(0).getDataType() == AttributeType.COMPOUND) {
            return this.getAtomicAttributesFromList(Lists.newArrayList((Iterable)outputAttrs.get(0).getChildren()));
        }
        return outputAttrs;
    }

    private Map<String, String> toMap(Iterable<Attribute> attrs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Attribute attr : attrs) {
            result.put(attr.getName(), attr.getDataType().toString());
        }
        return result;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

