/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.dataexplorer.directory.DirectorySettings;
import org.molgenis.dataexplorer.directory.NegotiatorQuery;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.web.PluginController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/plugin/directory"})
public class DirectoryController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryController.class);
    public static final String ID = "directory";
    public static final String URI = "/plugin/directory";
    private final DirectorySettings settings;
    private final RestTemplate restTemplate;
    private final PermissionService permissions;

    @Autowired
    public DirectoryController(DirectorySettings settings, RestTemplate restTemplate, PermissionService permissions) {
        super(URI);
        this.settings = Objects.requireNonNull(settings);
        this.restTemplate = Objects.requireNonNull(restTemplate);
        this.permissions = Objects.requireNonNull(permissions);
    }

    @RunAsSystem
    public boolean showDirectoryButton(String selectedEntityName) {
        if (!this.permissions.hasPermissionOnPlugin(ID, Permission.READ)) {
            return false;
        }
        EntityType collectionEntityType = this.settings.getCollectionEntityType();
        return collectionEntityType != null && collectionEntityType.getId().equals(selectedEntityName);
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public String exportToNegotiator(@RequestBody NegotiatorQuery query) throws Exception {
        LOG.info("NegotiatorQuery\n\n" + query + "\n\nreceived, sending request");
        String username = this.settings.getUsername();
        String password = this.settings.getPassword();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", DirectoryController.generateBase64Authentication(username, password));
        HttpEntity entity = new HttpEntity((Object)query, (MultiValueMap)headers);
        try {
            LOG.trace("DirectorySettings.NEGOTIATOR_URL: [{}]", (Object)this.settings.getNegotiatorURL());
            String redirectURL = this.restTemplate.postForLocation(this.settings.getNegotiatorURL(), (Object)entity, new Object[0]).toASCIIString();
            LOG.trace("Redirecting to " + redirectURL);
            return redirectURL;
        }
        catch (Exception e) {
            LOG.error("Posting to the directory went wrong: ", (Throwable)e);
            throw e;
        }
    }

    private static String generateBase64Authentication(String username, String password) {
        Objects.requireNonNull(username, password);
        String userPass = username + ":" + password;
        String userPassBase64 = Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
        return "Basic " + userPassBase64;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

