/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.directory;

import javax.annotation.Nullable;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.settings.DefaultSettingsEntity;
import org.molgenis.data.settings.DefaultSettingsEntityType;
import org.springframework.stereotype.Component;

@Component
public class DirectorySettings
extends DefaultSettingsEntity {
    private static final long serialVersionUID = 1L;
    public static final String COLLECTION_ENTITY = "collection_entity";
    public static final String NEGOTIATOR_URL = "negotiator_url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    private static final String NEGOTIATOR_URL_DEFAULT = "https://bbmri-dev.mitro.dkfz.de/api/directory/create_query";
    private static final String ID = "directory";

    public DirectorySettings() {
        super(ID);
    }

    @Nullable
    public String getUsername() {
        return this.getString(USERNAME);
    }

    @Nullable
    public String getPassword() {
        return this.getString(PASSWORD);
    }

    @Nullable
    public String getNegotiatorURL() {
        return this.getString(NEGOTIATOR_URL);
    }

    @Nullable
    public EntityType getCollectionEntityType() {
        return (EntityType)this.getEntity(COLLECTION_ENTITY, EntityType.class);
    }

    @Component
    public static class Meta
    extends DefaultSettingsEntityType {
        private EntityTypeMetadata entityTypeMetadata;

        public Meta(EntityTypeMetadata entityTypeMetadata) {
            super(DirectorySettings.ID);
            this.entityTypeMetadata = entityTypeMetadata;
        }

        public void init() {
            super.init();
            this.setLabel("Directory settings");
            this.setDescription("Settings for the Directory - Negotiator interaction.");
            this.addAttribute(DirectorySettings.NEGOTIATOR_URL, new EntityType.AttributeRole[0]).setLabel("Negotiator endpoint url").setDefaultValue(DirectorySettings.NEGOTIATOR_URL_DEFAULT).setDescription("URL to post negotiator queries to.");
            this.addAttribute(DirectorySettings.USERNAME, new EntityType.AttributeRole[0]).setLabel("Username").setDescription("Username to use in the basic authentication with the negotiator endbpoint.");
            this.addAttribute(DirectorySettings.PASSWORD, new EntityType.AttributeRole[0]).setLabel("Password").setDescription("Password to use in the basic authentication with the negotiator endpoint.");
            this.addAttribute(DirectorySettings.COLLECTION_ENTITY, new EntityType.AttributeRole[0]).setLabel("Collection entity").setDescription("Entity containing biobank collections.").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.entityTypeMetadata);
        }
    }
}

