/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.negotiator;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Query;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.rest.convert.QueryRsqlConverter;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.dataexplorer.negotiator.Collection;
import org.molgenis.dataexplorer.negotiator.ExportValidationResponse;
import org.molgenis.dataexplorer.negotiator.NegotiatorQuery;
import org.molgenis.dataexplorer.negotiator.NegotiatorRequest;
import org.molgenis.dataexplorer.negotiator.config.NegotiatorConfig;
import org.molgenis.dataexplorer.negotiator.config.NegotiatorEntityConfig;
import org.molgenis.js.magma.JsMagmaScriptEvaluator;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.util.ErrorMessageResponse;
import org.molgenis.web.PluginController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceResourceBundle;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Controller
@RequestMapping(value={"/plugin/directory"})
public class NegotiatorController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(NegotiatorController.class);
    private static final String ID = "directory";
    static final String URI = "/plugin/directory";
    private final RestTemplate restTemplate;
    private final PermissionService permissions;
    private final DataService dataService;
    private final QueryRsqlConverter rsqlQueryConverter;
    private final LanguageService languageService;
    private final JsMagmaScriptEvaluator jsMagmaScriptEvaluator;

    public NegotiatorController(RestTemplate restTemplate, PermissionService permissions, DataService dataService, QueryRsqlConverter rsqlQueryConverter, LanguageService languageService, JsMagmaScriptEvaluator jsMagmaScriptEvaluator) {
        super(URI);
        this.restTemplate = Objects.requireNonNull(restTemplate);
        this.permissions = Objects.requireNonNull(permissions);
        this.dataService = Objects.requireNonNull(dataService);
        this.rsqlQueryConverter = Objects.requireNonNull(rsqlQueryConverter);
        this.languageService = Objects.requireNonNull(languageService);
        this.jsMagmaScriptEvaluator = Objects.requireNonNull(jsMagmaScriptEvaluator);
    }

    @RunAsSystem
    public boolean showDirectoryButton(String entityTypeId) {
        NegotiatorEntityConfig settings = this.getNegotiatorEntityConfig(entityTypeId);
        return settings != null && this.permissions.hasPermissionOnPlugin(ID, Permission.READ);
    }

    @PostMapping(value={"/validate"})
    @ResponseBody
    public ExportValidationResponse validateNegotiatorExport(@RequestBody NegotiatorRequest request) {
        List<String> enabledCollectionsLabels;
        List<String> disabledCollectionLabels;
        MessageSourceResourceBundle i18n = this.languageService.getBundle();
        boolean isValidRequest = true;
        String message = "";
        NegotiatorEntityConfig entityConfig = this.getNegotiatorEntityConfig(request.getEntityId());
        if (null != entityConfig) {
            LOG.info("Validating negotiator request\n\n{}", (Object)request);
            List<Entity> collectionEntities = this.getCollectionEntities(request);
            List<Entity> disabledCollections = this.getDisabledCollections(collectionEntities, entityConfig);
            Function<Entity, String> getLabel = entity -> entity.getLabelValue().toString();
            disabledCollectionLabels = disabledCollections.stream().map(getLabel).collect(Collectors.toList());
            enabledCollectionsLabels = collectionEntities.stream().filter(e -> !disabledCollections.contains(e)).map(getLabel).collect(Collectors.toList());
            if (!disabledCollections.isEmpty()) {
                message = String.format(i18n.getString("dataexplorer_directory_disabled"), disabledCollections.size(), collectionEntities.size());
            }
            if (collectionEntities.isEmpty() || collectionEntities.size() == disabledCollections.size()) {
                isValidRequest = false;
                message = i18n.getString("dataexplorer_directory_no_rows");
            }
        } else {
            throw new MolgenisDataException(i18n.getString("dataexplorer_directory_no_config"));
        }
        return ExportValidationResponse.create(isValidRequest, message, enabledCollectionsLabels, disabledCollectionLabels);
    }

    @PostMapping(value={"/export"})
    @ResponseBody
    public String exportToNegotiator(@RequestBody NegotiatorRequest request) {
        LOG.info("Sending Negotiator request");
        NegotiatorEntityConfig entityConfig = this.getNegotiatorEntityConfig(request.getEntityId());
        NegotiatorConfig config = entityConfig.getNegotiatorConfig();
        String expression = config.getString("enabledExpression");
        List<Collection> nonDisabledCollectionEntities = this.getCollectionEntities(request).stream().filter(entity -> expression == null || this.evaluateExpressionOnEntity(expression, (Entity)entity)).map(entity -> this.getEntityCollection(entityConfig, (Entity)entity)).collect(Collectors.toList());
        HttpEntity<NegotiatorQuery> queryHttpEntity = this.getNegotiatorQueryHttpEntity(request, config, nonDisabledCollectionEntities);
        return this.postQueryToNegotiator(config, queryHttpEntity);
    }

    private Collection getEntityCollection(NegotiatorEntityConfig entityConfig, Entity entity) {
        Attribute collectionAttr = (Attribute)entityConfig.getEntity("collectionId", Attribute.class);
        Attribute biobankAttr = (Attribute)entityConfig.getEntity("biobankId", Attribute.class);
        String biobankString = this.getStringValue(biobankAttr, entity);
        String collectionString = this.getStringValue(collectionAttr, entity);
        return Collection.create(collectionString, biobankString);
    }

    private String getStringValue(Attribute attribute, Entity entity) {
        Object value = entity.get(attribute.getName());
        if (EntityTypeUtils.isMultipleReferenceType((Attribute)attribute)) {
            throw new MolgenisDataException(String.format("The %s cannot be a mref of categorical mref", attribute.getName()));
        }
        String stringValue = EntityTypeUtils.isReferenceType((Attribute)attribute) ? (value != null ? ((Entity)value).getIdValue().toString() : "") : (value != null ? value.toString() : "");
        return stringValue;
    }

    private String postQueryToNegotiator(NegotiatorConfig config, HttpEntity<NegotiatorQuery> queryHttpEntity) {
        try {
            LOG.trace("NEGOTIATOR_URL: [{}]", (Object)config.getNegotiatorURL());
            String redirectURL = this.restTemplate.postForLocation(config.getNegotiatorURL(), queryHttpEntity, new Object[0]).toASCIIString();
            LOG.trace("Redirecting to %s", (Object)redirectURL);
            return redirectURL;
        }
        catch (RestClientException e) {
            LOG.error("Posting to the negotiator went wrong: ", (Throwable)e);
            throw e;
        }
    }

    private List<Entity> getCollectionEntities(NegotiatorRequest request) {
        EntityType selectedEntityType = this.dataService.getEntityType(request.getEntityId());
        Query molgenisQuery = this.rsqlQueryConverter.convert(request.getRsql()).createQuery(selectedEntityType);
        return this.dataService.findAll(selectedEntityType.getId(), molgenisQuery).collect(Collectors.toList());
    }

    private List<Entity> getDisabledCollections(List<Entity> entities, NegotiatorEntityConfig config) {
        String expression = config.getString("enabledExpression");
        return entities.stream().filter(entity -> !this.evaluateExpressionOnEntity(expression, (Entity)entity)).collect(Collectors.toList());
    }

    private boolean evaluateExpressionOnEntity(String expression, Entity entity) {
        return expression == null ? true : Boolean.valueOf(this.jsMagmaScriptEvaluator.eval(expression, entity).toString());
    }

    private HttpEntity<NegotiatorQuery> getNegotiatorQueryHttpEntity(NegotiatorRequest request, NegotiatorConfig config, List<Collection> collections) {
        NegotiatorQuery query = NegotiatorQuery.create(request.getURL(), collections, request.getHumanReadable(), request.getnToken());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String username = config.getUsername();
        String password = config.getPassword();
        headers.set("Authorization", NegotiatorController.generateBase64Authentication(username, password));
        return new HttpEntity((Object)query, (MultiValueMap)headers);
    }

    private NegotiatorEntityConfig getNegotiatorEntityConfig(String entityId) {
        Query query = new QueryImpl().eq("entity", (Object)entityId);
        return (NegotiatorEntityConfig)this.dataService.findOne("sys_negotiator_NegotiatorEntityConfig", query, NegotiatorEntityConfig.class);
    }

    private static String generateBase64Authentication(String username, String password) {
        Objects.requireNonNull(username, password);
        String userPass = username + ":" + password;
        String userPassBase64 = Base64.getEncoder().encodeToString(userPass.getBytes(StandardCharsets.UTF_8));
        return "Basic " + userPassBase64;
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error(e.getMessage(), (Throwable)e);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage("An error occurred. Please contact the administrator.<br />Message:" + e.getMessage()));
    }
}

