/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.annotation.core.RepositoryAnnotator;
import org.molgenis.data.annotation.core.utils.AnnotatorDependencyOrderResolver;
import org.molgenis.data.annotation.web.AnnotationService;
import org.molgenis.data.annotation.web.CrudRepositoryAnnotator;
import org.molgenis.data.annotation.web.meta.AnnotationJobExecution;
import org.molgenis.data.meta.model.EntityTypeFactory;
import org.molgenis.dataexplorer.controller.AnnotationJob;
import org.molgenis.jobs.JobExecutionUpdater;
import org.molgenis.jobs.Progress;
import org.molgenis.jobs.ProgressImpl;
import org.molgenis.jobs.model.JobExecution;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class AnnotationJobFactory {
    @Autowired
    CrudRepositoryAnnotator crudRepositoryAnnotator;
    @Autowired
    DataService dataService;
    @Autowired
    private AnnotationService annotationService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private JobExecutionUpdater jobExecutionUpdater;
    @Autowired
    private MailSender mailSender;
    @Autowired
    private EntityTypeFactory entityTypeFactory;

    @RunAsSystem
    public AnnotationJob createJob(AnnotationJobExecution metaData) {
        this.dataService.add("sys_job_AnnotationJobExecution", (Entity)metaData);
        String annotatorNames = metaData.getAnnotators();
        String targetName = metaData.getTargetName();
        String username = metaData.getUser();
        RunAsUserToken runAsAuthentication = new RunAsUserToken("Job Execution", (Object)username, null, this.userDetailsService.loadUserByUsername(username).getAuthorities(), null);
        Repository repository = this.dataService.getRepository(targetName);
        List availableAnnotators = this.annotationService.getAllAnnotators().stream().filter(RepositoryAnnotator::annotationDataExists).collect(Collectors.toList());
        List requestedAnnotators = Arrays.stream(annotatorNames.split(",")).map(arg_0 -> ((AnnotationService)this.annotationService).getAnnotatorByName(arg_0)).collect(Collectors.toList());
        AnnotatorDependencyOrderResolver resolver = new AnnotatorDependencyOrderResolver();
        ArrayList annotators = Lists.newArrayList((Iterable)resolver.getAnnotatorSelectionDependencyList(availableAnnotators, requestedAnnotators, repository, this.entityTypeFactory));
        return new AnnotationJob(this.crudRepositoryAnnotator, username, annotators, (Repository<Entity>)repository, (Progress)new ProgressImpl((JobExecution)metaData, this.jobExecutionUpdater, this.mailSender), (Authentication)runAsAuthentication, new TransactionTemplate(this.transactionManager));
    }
}

