/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.gson.Gson;
import freemarker.core.ParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.molgenis.core.ui.menu.MenuReaderService;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.Sort;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.util.EntityUtils;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.molgenis.dataexplorer.controller.ModuleConfig;
import org.molgenis.dataexplorer.controller.ModulesConfigResponse;
import org.molgenis.dataexplorer.controller.NavigatorLink;
import org.molgenis.dataexplorer.download.DataExplorerDownloadHandler;
import org.molgenis.dataexplorer.negotiator.NegotiatorController;
import org.molgenis.dataexplorer.settings.DataExplorerSettings;
import org.molgenis.genomebrowser.GenomeBrowserTrack;
import org.molgenis.genomebrowser.service.GenomeBrowserService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.settings.AppSettings;
import org.molgenis.util.UnexpectedEnumException;
import org.molgenis.web.PluginController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Controller
@RequestMapping(value={"/plugin/dataexplorer"})
public class DataExplorerController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(DataExplorerController.class);
    public static final String ID = "dataexplorer";
    public static final String URI = "/plugin/dataexplorer";
    public static final String MOD_ANNOTATORS = "annotators";
    public static final String MOD_ENTITIESREPORT = "entitiesreport";
    public static final String MOD_DATA = "data";
    public static final String NAVIGATOR = "navigator";
    @Autowired
    private DataExplorerSettings dataExplorerSettings;
    @Autowired
    private NegotiatorController directoryController;
    @Autowired
    private DataService dataService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    @Autowired
    private Gson gson;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AttributeFactory attrMetaFactory;
    @Autowired
    private GenomeBrowserService genomeBrowserService;
    @Autowired
    private MenuReaderService menuReaderService;
    @Autowired
    private AppSettings appSettings;

    public DataExplorerController() {
        super(URI);
    }

    @GetMapping
    public String init(@RequestParam(value="entity", required=false) String selectedEntityName, @RequestParam(value="entityId", required=false) String selectedEntityId, Model model) {
        StringBuilder message = new StringBuilder("");
        boolean currentUserIsSu = SecurityUtils.currentUserIsSu();
        Map entitiesMeta = this.dataService.getMeta().getEntityTypes().filter(entityType -> !entityType.isAbstract()).filter(entityType -> currentUserIsSu || !EntityTypeUtils.isSystemEntity((EntityType)entityType)).sorted(Comparator.comparing(EntityType::getLabel)).collect(Collectors.toMap(EntityType::getId, Function.identity(), (e1, e2) -> e2, LinkedHashMap::new));
        model.addAttribute("entitiesMeta", (Object)entitiesMeta);
        if (selectedEntityId != null && selectedEntityName == null) {
            EntityType entityType2 = this.dataService.getMeta().getEntityType(selectedEntityId);
            if (entityType2 == null) {
                message.append("Entity does not exist or you do not have permission on this entity");
            } else {
                selectedEntityName = entityType2.getId();
            }
            if (selectedEntityName != null) {
                this.checkExistsAndPermission(selectedEntityName, message);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)message.toString())) {
            model.addAttribute("warningMessage", (Object)message.toString());
        }
        model.addAttribute("selectedEntityName", (Object)selectedEntityName);
        model.addAttribute("isAdmin", (Object)currentUserIsSu);
        boolean navigatorAvailable = this.menuReaderService.getMenu().findMenuItemPath(NAVIGATOR) != null;
        model.addAttribute("showNavigatorLink", (Object)(this.dataExplorerSettings.isShowNavigatorLink() && navigatorAvailable ? 1 : 0));
        model.addAttribute("hasTrackingId", (Object)(null != this.appSettings.getGoogleAnalyticsTrackingId() ? 1 : 0));
        model.addAttribute("hasMolgenisTrackingId", (Object)(null != this.appSettings.getGoogleAnalyticsTrackingIdMolgenis() ? 1 : 0));
        return "view-dataexplorer";
    }

    private void checkExistsAndPermission(@RequestParam(value="entity", required=false) String selectedEntityName, StringBuilder message) {
        boolean entityExists = this.dataService.hasRepository(selectedEntityName);
        boolean hasEntityPermission = this.permissionService.hasPermissionOnEntityType(selectedEntityName, Permission.COUNT);
        if (!(entityExists && hasEntityPermission || selectedEntityName == null)) {
            message.append("Entity does not exist or you do not have permission on this entity");
            if (!SecurityUtils.currentUserIsAuthenticated()) {
                message.append(", log in to view more entities");
            } else {
                message.append(", please specify the fully qualified entity name");
            }
        }
    }

    @GetMapping(value={"/module/{moduleId}"})
    public String getModule(@PathVariable(value="moduleId") String moduleId, @RequestParam(value="entity") String entityTypeId, Model model) {
        switch (moduleId) {
            case "data": {
                EntityType selectedEntityType = this.dataService.getMeta().getEntityTypeById(entityTypeId);
                Map entityTracks = this.genomeBrowserService.getGenomeBrowserTracks(selectedEntityType);
                model.addAttribute("genomeTracks", this.getTracksJson(entityTracks));
                if (!entityTracks.isEmpty()) {
                    GenomeBrowserTrack track = (GenomeBrowserTrack)entityTracks.entrySet().iterator().next().getValue();
                    model.addAttribute("pos_attr", (Object)track.getGenomeBrowserAttrs().getPos());
                    model.addAttribute("chrom_attr", (Object)track.getGenomeBrowserAttrs().getChrom());
                }
                model.addAttribute("showDirectoryButton", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("NegotiatorEnabled", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                break;
            }
            case "entitiesreport": {
                EntityType selectedEntityType = this.dataService.getMeta().getEntityTypeById(entityTypeId);
                Map entityTracks = this.genomeBrowserService.getGenomeBrowserTracks(selectedEntityType);
                model.addAttribute("genomeTracks", this.getTracksJson(entityTracks));
                model.addAttribute("showDirectoryButton", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("NegotiatorEnabled", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("datasetRepository", (Object)this.dataService.getRepository(entityTypeId));
                model.addAttribute("viewName", (Object)this.dataExplorerSettings.getEntityReport(entityTypeId));
                break;
            }
            case "annotators": {
                if (!this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.WRITEMETA)) {
                    throw new MolgenisDataAccessException("No " + Permission.WRITEMETA + " permission on entity [" + entityTypeId + "], this permission is necessary run the annotators.");
                }
                Entity annotationRun = this.dataService.findOne("sys_job_AnnotationJobExecution", new QueryImpl().eq("targetName", (Object)entityTypeId).sort(new Sort("startDate", Sort.Direction.DESC)));
                model.addAttribute("annotationRun", (Object)annotationRun);
                model.addAttribute("entityTypeId", (Object)entityTypeId);
            }
        }
        return "view-dataexplorer-mod-" + moduleId;
    }

    @GetMapping(value={"/copy"})
    @ResponseBody
    public boolean showCopy(@RequestParam(value="entity") String entityTypeId) {
        return this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.READ) && this.dataService.getCapabilities(entityTypeId).contains(RepositoryCapability.WRITABLE);
    }

    @GetMapping(value={"/modules"})
    @ResponseBody
    public ModulesConfigResponse getModules(@RequestParam(value="entity") String entityTypeId) {
        boolean modAggregates = this.dataExplorerSettings.getModAggregates();
        boolean modAnnotators = this.dataExplorerSettings.getModAnnotators();
        boolean modData = this.dataExplorerSettings.getModData();
        boolean modReports = this.dataExplorerSettings.getModReports();
        if (modAggregates) {
            modAggregates = this.dataService.getCapabilities(entityTypeId).contains(RepositoryCapability.AGGREGATEABLE);
        }
        Permission pluginPermission = null;
        if (this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.WRITE)) {
            pluginPermission = Permission.WRITE;
        } else if (this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.READ)) {
            pluginPermission = Permission.READ;
        } else if (this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.COUNT)) {
            pluginPermission = Permission.COUNT;
        }
        ModulesConfigResponse modulesConfig = new ModulesConfigResponse();
        String aggregatesTitle = this.messageSource.getMessage("dataexplorer_aggregates_title", new Object[0], LocaleContextHolder.getLocale());
        if (pluginPermission != null) {
            switch (pluginPermission) {
                case COUNT: {
                    if (!modAggregates) break;
                    modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "grid-icon.png"));
                    break;
                }
                case READ: 
                case WRITE: {
                    String modEntitiesReportName;
                    if (modData) {
                        modulesConfig.add(new ModuleConfig(MOD_DATA, "Data", "grid-icon.png"));
                    }
                    if (modAggregates) {
                        modulesConfig.add(new ModuleConfig("aggregates", aggregatesTitle, "aggregate-icon.png"));
                    }
                    if (modAnnotators && pluginPermission == Permission.WRITE) {
                        modulesConfig.add(new ModuleConfig(MOD_ANNOTATORS, "Annotators", "annotator-icon.png"));
                    }
                    if (!modReports || (modEntitiesReportName = this.dataExplorerSettings.getEntityReport(entityTypeId)) == null) break;
                    modulesConfig.add(new ModuleConfig(MOD_ENTITIESREPORT, modEntitiesReportName, "report-icon.png"));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)pluginPermission);
                }
            }
        }
        return modulesConfig;
    }

    @GetMapping(value={"/navigatorLinks"})
    @ResponseBody
    public List<NavigatorLink> getNavigatorLinks(@RequestParam(value="entity") String entityTypeId) {
        LinkedList<NavigatorLink> result = new LinkedList<NavigatorLink>();
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        String navigatorPath = this.menuReaderService.getMenu().findMenuItemPath(NAVIGATOR);
        if (entityType != null) {
            Package pack = entityType.getPackage();
            this.getNavigatorLinks(result, pack, navigatorPath);
            result.add(NavigatorLink.create(navigatorPath + "/", "glyphicon-home"));
            Collections.reverse(result);
        }
        return result;
    }

    private void getNavigatorLinks(List<NavigatorLink> result, Package pack, String navigatorPath) {
        if (pack != null) {
            String label = pack.getLabel();
            String href = navigatorPath + "/" + pack.getId();
            result.add(NavigatorLink.create(href, label));
            pack = pack.getParent();
            this.getNavigatorLinks(result, pack, navigatorPath);
        }
    }

    private List<JSONObject> getTracksJson(Map<String, GenomeBrowserTrack> entityTracks) {
        HashMap<String, GenomeBrowserTrack> allTracks = new HashMap<String, GenomeBrowserTrack>();
        allTracks.putAll(entityTracks);
        for (GenomeBrowserTrack track2 : entityTracks.values()) {
            allTracks.putAll(this.genomeBrowserService.getReferenceTracks(track2));
        }
        return allTracks.values().stream().map(track -> track.toTrackJson()).collect(Collectors.toList());
    }

    @PostMapping(value={"/download"})
    public void download(@RequestParam(value="dataRequest") String dataRequestStr, HttpServletResponse response) throws IOException {
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService, this.attrMetaFactory);
        dataRequestStr = URLDecoder.decode(dataRequestStr, "UTF-8");
        LOG.info("Download request: [" + dataRequestStr + "]");
        DataRequest dataRequest = (DataRequest)this.gson.fromJson(dataRequestStr, DataRequest.class);
        String fileName = this.getDownloadFilename(dataRequest.getEntityName(), LocalDateTime.now(), dataRequest.getDownloadType());
        switch (dataRequest.getDownloadType()) {
            case DOWNLOAD_TYPE_CSV: {
                response.setContentType("text/csv");
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                ServletOutputStream outputStream = response.getOutputStream();
                download.writeToCsv(dataRequest, (OutputStream)outputStream, ',');
                break;
            }
            case DOWNLOAD_TYPE_XLSX: {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                ServletOutputStream outputStream = response.getOutputStream();
                download.writeToExcel(dataRequest, (OutputStream)outputStream);
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)dataRequest.getDownloadType());
            }
        }
    }

    public String getDownloadFilename(String entityTypeId, LocalDateTime localDateTime, DataRequest.DownloadType downloadType) {
        String timestamp = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss"));
        return String.format("%s_%s.%s", entityTypeId, timestamp, downloadType == DataRequest.DownloadType.DOWNLOAD_TYPE_CSV ? "csv" : "xlsx");
    }

    @PostMapping(value={"/details"})
    public String viewEntityDetails(@RequestParam(value="entityTypeId") String entityTypeId, @RequestParam(value="entityId") String entityId, Model model) {
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        Object id = EntityUtils.getTypedValue((String)entityId, (Attribute)entityType.getIdAttribute());
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityTypeId).findOneById(id));
        model.addAttribute("entityType", (Object)entityType);
        model.addAttribute("viewName", (Object)this.getEntityReportViewName(entityTypeId));
        model.addAttribute("showStandaloneReportUrl", (Object)this.dataExplorerSettings.getModStandaloneReports());
        model.addAttribute("entityTypeId", (Object)entityTypeId);
        model.addAttribute("entityId", (Object)entityId);
        return "view-entityreport";
    }

    @GetMapping(value={"/details/{entityTypeId}/{entityId}"})
    public String viewEntityDetailsById(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="entityId") String entityId, Model model) throws Exception {
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        if (entityType == null) {
            throw new MolgenisDataAccessException("EntityType with id [" + entityTypeId + "] does not exist. Did you use the correct URL?");
        }
        Object id = EntityUtils.getTypedValue((String)entityId, (Attribute)entityType.getIdAttribute());
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityTypeId).findOneById(id));
        model.addAttribute("entityType", (Object)entityType);
        model.addAttribute("entityTypeId", (Object)entityTypeId);
        model.addAttribute("viewName", (Object)this.getStandaloneReportViewName(entityTypeId));
        return "view-standalone-report";
    }

    private String getEntityReportViewName(String entityTypeId) {
        String specificViewname;
        String reportTemplate = this.dataExplorerSettings.getEntityReport(entityTypeId);
        if (reportTemplate != null && this.viewExists(specificViewname = "view-entityreport-specific-" + reportTemplate)) {
            return specificViewname;
        }
        specificViewname = "view-entityreport-specific-" + entityTypeId;
        if (this.viewExists(specificViewname)) {
            return specificViewname;
        }
        if (this.viewExists("view-entityreport-generic")) {
            return "view-entityreport-generic";
        }
        return "view-entityreport-generic-default";
    }

    private String getStandaloneReportViewName(String entityTypeId) {
        String specificStandaloneReportViewName = "view-standalone-report-specific-" + entityTypeId;
        if (this.viewExists(specificStandaloneReportViewName)) {
            return specificStandaloneReportViewName;
        }
        return "view-standalone-report-default";
    }

    private boolean viewExists(String viewName) {
        try {
            return this.freemarkerConfigurer.getConfiguration().getTemplate(viewName + ".ftl") != null;
        }
        catch (ParseException e) {
            LOG.info("error parsing template: ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

