/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.decorator;

import java.util.Objects;
import org.molgenis.core.ui.data.system.core.FreemarkerTemplate;
import org.molgenis.core.ui.data.system.core.FreemarkerTemplateMetaData;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.Repository;
import org.molgenis.data.decorator.PermissionChecker;
import org.molgenis.data.decorator.PermissionCheckingDecorator;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.dataexplorer.decorator.EntityReportPermissionChecker;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.springframework.stereotype.Component;

@Component
public class EntityReportDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<FreemarkerTemplate, FreemarkerTemplateMetaData> {
    private final UserPermissionEvaluator permissionEvaluator;

    public EntityReportDecoratorFactory(FreemarkerTemplateMetaData entityType, UserPermissionEvaluator permissionEvaluator) {
        super((SystemEntityType)entityType);
        this.permissionEvaluator = Objects.requireNonNull(permissionEvaluator);
    }

    public Repository<FreemarkerTemplate> createDecoratedRepository(Repository<FreemarkerTemplate> repository) {
        return new PermissionCheckingDecorator(repository, (PermissionChecker)new EntityReportPermissionChecker(this.permissionEvaluator));
    }
}

