/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.negotiator.config;

import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.AttributeMetadata;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.meta.model.Package;
import org.molgenis.dataexplorer.negotiator.config.NegotiatorConfigMeta;
import org.molgenis.dataexplorer.negotiator.config.NegotiatorPackage;
import org.springframework.stereotype.Component;

@Component
public class NegotiatorEntityConfigMeta
extends SystemEntityType {
    private static final String SIMPLE_NAME = "NegotiatorEntityConfig";
    public static final String NEGOTIATORENTITYCONFIG = "sys_negotiator_NegotiatorEntityConfig";
    private static final String IDENTIFIER = "id";
    public static final String COLLECTION_ID = "collectionId";
    public static final String BIOBANK_ID = "biobankId";
    public static final String ENTITY = "entity";
    public static final String ENABLED_EXPRESSION = "enabledExpression";
    public static final String NEGOTIATOR_CONFIG = "negotiatorConfig";
    private final EntityTypeMetadata entityTypeMetadata;
    private final AttributeMetadata attributeMetadata;
    private final NegotiatorPackage negotiatorPackage;
    private final NegotiatorConfigMeta negotiatorConfigMeta;

    public NegotiatorEntityConfigMeta(AttributeMetadata attributeMetadata, EntityTypeMetadata entityTypeMetadata, NegotiatorPackage negotiatorPackage, NegotiatorConfigMeta negotiatorConfigMeta) {
        super(SIMPLE_NAME, "sys_negotiator");
        this.entityTypeMetadata = Objects.requireNonNull(entityTypeMetadata);
        this.attributeMetadata = Objects.requireNonNull(attributeMetadata);
        this.negotiatorPackage = Objects.requireNonNull(negotiatorPackage);
        this.negotiatorConfigMeta = Objects.requireNonNull(negotiatorConfigMeta);
    }

    protected void init() {
        this.setLabel("Negotiator Entity Config");
        this.setPackage((Package)this.negotiatorPackage);
        this.addAttribute(IDENTIFIER, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setLabel("Identifier").setAuto(false).setNillable(false).setDescription("Identifier for this entity config");
        this.addAttribute(ENTITY, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.entityTypeMetadata).setNillable(false).setLabel("Entity to use in negotiator");
        this.addAttribute(NEGOTIATOR_CONFIG, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.negotiatorConfigMeta).setNillable(false).setLabel("General negotiator settings");
        this.addAttribute(COLLECTION_ID, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.attributeMetadata).setNillable(false).setLabel("Attribute containing the collection");
        this.addAttribute(BIOBANK_ID, new EntityType.AttributeRole[0]).setDataType(AttributeType.XREF).setRefEntity((EntityType)this.attributeMetadata).setNillable(false).setLabel("Attribute containing the biobank");
        this.addAttribute(ENABLED_EXPRESSION, new EntityType.AttributeRole[0]).setDataType(AttributeType.SCRIPT).setNillable(true).setLabel("Negotiator enabled expression").setDescription("Expression to determine if the row is enabled for usage with the negotiator");
    }
}

