/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.download;

import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.csv.CsvWriter;
import org.molgenis.data.excel.ExcelSheetWriter;
import org.molgenis.data.excel.ExcelWriter;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.AbstractWritable;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.molgenis.util.UnexpectedEnumException;

public class DataExplorerDownloadHandler {
    private static final long MAX_EXCEL_CELLS = 500000L;
    private final DataService dataService;
    private final AttributeFactory attrMetaFactory;

    public DataExplorerDownloadHandler(DataService dataService, AttributeFactory attrMetaFactory) {
        this.dataService = Objects.requireNonNull(dataService);
        this.attrMetaFactory = Objects.requireNonNull(attrMetaFactory);
    }

    public void writeToExcel(DataRequest dataRequest, OutputStream outputStream) throws IOException {
        String entityTypeId = dataRequest.getEntityName();
        List<Attribute> attributes = this.filterAttributes(dataRequest);
        this.checkNumberOfCells(dataRequest, entityTypeId, attributes.size());
        AbstractWritable.AttributeWriteMode attributeWriteMode = this.getAttributeWriteMode(dataRequest.getColNames());
        try (ExcelWriter excelWriter = new ExcelWriter(outputStream, this.attrMetaFactory, ExcelWriter.FileFormat.XLSX);
             ExcelSheetWriter excelSheetWriter = excelWriter.createWritable(entityTypeId, attributes, attributeWriteMode);){
            excelSheetWriter.setEntityWriteMode(this.getEntityWriteMode(dataRequest.getEntityValues()));
            excelSheetWriter.add(this.dataService.findAll(entityTypeId, dataRequest.getQuery()));
        }
    }

    private List<Attribute> filterAttributes(DataRequest dataRequest) {
        EntityType entityType = this.dataService.getEntityType(dataRequest.getEntityName());
        HashSet attributeNames = Sets.newHashSet(dataRequest.getAttributeNames());
        return Streams.stream((Iterable)entityType.getAtomicAttributes()).filter(attribute -> attributeNames.contains(attribute.getName())).collect(Collectors.toList());
    }

    private void checkNumberOfCells(DataRequest dataRequest, String entityTypeId, int cols) {
        long rows = this.dataService.count(entityTypeId, dataRequest.getQuery());
        if (rows * (long)cols >= 500000L) {
            throw new MolgenisDataException(String.format("Total number of cells for this download exceeds the maximum of %s for .xlsx downloads, please use .csv instead", 500000L));
        }
    }

    public void writeToCsv(DataRequest request, OutputStream outputStream, char separator) throws IOException {
        this.writeToCsv(request, outputStream, separator, false);
    }

    public void writeToCsv(DataRequest dataRequest, OutputStream outputStream, char separator, boolean noQuotes) throws IOException {
        try (CsvWriter csvWriter = new CsvWriter(outputStream, separator, noQuotes);){
            csvWriter.setEntityWriteMode(this.getEntityWriteMode(dataRequest.getEntityValues()));
            String entityTypeId = dataRequest.getEntityName();
            this.writeCsvHeaders(dataRequest, csvWriter);
            csvWriter.add(this.dataService.findAll(entityTypeId, dataRequest.getQuery()));
        }
    }

    private void writeCsvHeaders(DataRequest dataRequest, CsvWriter csvWriter) throws IOException {
        List<Attribute> attributes = this.filterAttributes(dataRequest);
        switch (dataRequest.getColNames()) {
            case ATTRIBUTE_LABELS: {
                csvWriter.writeAttributes(attributes);
                break;
            }
            case ATTRIBUTE_NAMES: {
                csvWriter.writeAttributeNames((Iterable)attributes.stream().map(Attribute::getName).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)dataRequest.getColNames());
            }
        }
    }

    private AbstractWritable.EntityWriteMode getEntityWriteMode(DataRequest.EntityValues entityValues) {
        switch (entityValues) {
            case ENTITY_IDS: {
                return AbstractWritable.EntityWriteMode.ENTITY_IDS;
            }
            case ENTITY_LABELS: {
                return AbstractWritable.EntityWriteMode.ENTITY_LABELS;
            }
        }
        throw new UnexpectedEnumException((Enum)entityValues);
    }

    private AbstractWritable.AttributeWriteMode getAttributeWriteMode(DataRequest.ColNames colNames) {
        switch (colNames) {
            case ATTRIBUTE_LABELS: {
                return AbstractWritable.AttributeWriteMode.ATTRIBUTE_LABELS;
            }
            case ATTRIBUTE_NAMES: {
                return AbstractWritable.AttributeWriteMode.ATTRIBUTE_NAMES;
            }
        }
        throw new UnexpectedEnumException((Enum)colNames);
    }
}

