/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.settings;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.settings.DefaultSettingsEntity;
import org.molgenis.settings.DefaultSettingsEntityType;
import org.springframework.stereotype.Component;

@Component
public class DataExplorerSettings
extends DefaultSettingsEntity {
    private static final long serialVersionUID = 1L;
    private static final String ID = "dataexplorer";

    public DataExplorerSettings() {
        super(ID);
    }

    public boolean getModAggregates() {
        return this.isTruthy(this.getBoolean("mod_aggregates"));
    }

    public void setModAggregates(boolean modAggregates) {
        this.set("mod_aggregates", modAggregates);
    }

    public boolean getModData() {
        return this.isTruthy(this.getBoolean("mod_data"));
    }

    public void setModData(boolean modData) {
        this.set("mod_data", modData);
    }

    public boolean getModReports() {
        return this.isTruthy(this.getBoolean("mod_reports"));
    }

    public boolean getModStandaloneReports() {
        return this.isTruthy(this.getBoolean("mod_standalone_reports"));
    }

    public void setModReports(boolean modReports) {
        this.set("mod_reports", modReports);
    }

    public void setModStandaloneReports(boolean modStandaloneReports) {
        this.set("mod_standalone_reports", modStandaloneReports);
    }

    public Map<String, String> getAggregatesDistinctOverrides() {
        String distinctAttrOverridesStr = this.getString("agg_distinct_overrides");
        return (Map)new Gson().fromJson(distinctAttrOverridesStr, new TypeToken<Map<String, String>>(){}.getType());
    }

    public void setAggregatesDistinctOverrides(Map<String, String> aggregatesDistinctOverrides) {
        String value = aggregatesDistinctOverrides != null ? new Gson().toJson(aggregatesDistinctOverrides) : null;
        this.set("agg_distinct_overrides", value);
    }

    public boolean getSearchbox() {
        return this.isTruthy(this.getBoolean("searchbox"));
    }

    public void setSearchbox(boolean searchbox) {
        this.set("searchbox", searchbox);
    }

    public boolean getItemSelection() {
        return this.isTruthy(this.getBoolean("item_select_panel"));
    }

    public void setItemSelection(boolean itemSelection) {
        this.set("item_select_panel", itemSelection);
    }

    public boolean getLaunchWizard() {
        return this.isTruthy(this.getBoolean("launch_wizard"));
    }

    public void setLaunchWizard(boolean launchWizard) {
        this.set("launch_wizard", launchWizard);
    }

    public int getHeaderAbbreviate() {
        Integer value = this.getInt("header_abbreviate");
        return value != null ? value : -1;
    }

    public void setHeaderAbbreviate(int headerAbbreviate) {
        this.set("header_abbreviate", headerAbbreviate);
    }

    public boolean getGenomeBrowser() {
        return this.isTruthy(this.getBoolean("data_genome_browser"));
    }

    public void setGenomeBrowser(boolean genomeBrowser) {
        this.set("data_genome_browser", genomeBrowser);
    }

    public String getGenomeBrowserLocation() {
        return this.getString("gb_init_location");
    }

    public void setGenomeBrowserLocation(String genomeBrowserLocation) {
        this.set("gb_init_location", genomeBrowserLocation);
    }

    public String getGenomeBrowserCoordSystem() {
        return this.getString("gb_init_coord_system");
    }

    public void setGenomeBrowserCoordSystem(String genomeBrowserCoordSystem) {
        this.set("gb_init_coord_system", genomeBrowserCoordSystem);
    }

    public String getGenomeBrowserSources() {
        return this.getString("gb_init_sources");
    }

    public void setGenomeBrowserSources(String genomeBrowserSources) {
        this.set("gb_init_sources", genomeBrowserSources);
    }

    public String getGenomeBrowserLinks() {
        return this.getString("gb_init_browser_links");
    }

    public void setGenomeBrowserLinks(String genomeBrowserLinks) {
        this.set("gb_init_browser_links", genomeBrowserLinks);
    }

    public boolean getGenomeBrowserHighlightRegion() {
        return this.isTruthy(this.getBoolean("gb_init_highlight_region"));
    }

    public void setGenomeBrowserHighlightRegion(boolean genomeBrowserHighlightRegion) {
        this.set("gb_init_highlight_region", genomeBrowserHighlightRegion);
    }

    public boolean getAggregatesDistinctSelect() {
        return this.isTruthy(this.getBoolean("agg_distinct"));
    }

    public void setAggregatesDistinctSelect(boolean aggregatesDistinctSelect) {
        this.set("agg_distinct", aggregatesDistinctSelect);
    }

    @Nullable
    public String getEntityReports() {
        return this.getString("reports_entities");
    }

    @Nullable
    public String getEntityReport(String entityTypeId) {
        Map<String, String> entityReports = this.getEntityReportsAsMap();
        return entityReports != null ? entityReports.get(entityTypeId) : null;
    }

    public void setEntityReports(String entityReportsStr) {
        this.set("reports_entities", entityReportsStr);
    }

    private Map<String, String> getEntityReportsAsMap() {
        String entityReportsStr = this.getEntityReports();
        if (entityReportsStr != null) {
            LinkedHashMap<String, String> entityReports = new LinkedHashMap<String, String>();
            for (String entityReport : entityReportsStr.split(",")) {
                String[] tokens = entityReport.split(":");
                String entityTypeId = tokens[0];
                String reportName = tokens[1];
                entityReports.put(entityTypeId, reportName);
            }
            return entityReports;
        }
        return null;
    }

    @Nullable
    public boolean isShowNavigatorLink() {
        return this.isTruthy(this.getBoolean("show_navigator_link"));
    }

    @Nullable
    public void setShowNavigatorLink(boolean showNavigatorLink) {
        this.set("show_navigator_link", showNavigatorLink);
    }

    public boolean isUseVueDataRowEdit() {
        return this.isTruthy(this.getBoolean("use_vue_data_row_edit"));
    }

    private boolean isTruthy(@Nullable Boolean input) {
        return input != null && input != false;
    }

    @Component
    private static class Meta
    extends DefaultSettingsEntityType {
        public static final String GENERAL = "general_";
        public static final String GENERAL_SEARCHBOX = "searchbox";
        public static final String GENERAL_ITEM_SELECT_PANEL = "item_select_panel";
        public static final String GENERAL_LAUNCH_WIZARD = "launch_wizard";
        public static final String GENERAL_HEADER_ABBREVIATE = "header_abbreviate";
        public static final String GENERAL_NAVIGATOR_LINK = "show_navigator_link";
        public static final String DATA_USE_VUE_ROW_EDIT = "use_vue_data_row_edit";
        private static final boolean DEFAULT_GENERAL_SEARCHBOX = true;
        private static final boolean DEFAULT_GENERAL_ITEM_SELECT_PANEL = true;
        private static final boolean DEFAULT_GENERAL_LAUNCH_WIZARD = false;
        private static final int DEFAULT_GENERAL_HEADER_ABBREVIATE = 180;
        public static final String MOD = "mods";
        public static final String MOD_AGGREGATES = "mod_aggregates";
        public static final String MOD_DATA = "mod_data";
        public static final String MOD_REPORTS = "mod_reports";
        public static final String MOD_STANDALONE_REPORTS = "mod_standalone_reports";
        private static final boolean DEFAULT_MOD_AGGREGATES = true;
        private static final boolean DEFAULT_MOD_DATA = true;
        private static final boolean DEFAULT_MOD_REPORT = true;
        private static final boolean DEFAULT_MOD_STANDALONE_REPORT = false;
        public static final String DATA = "data";
        public static final String DATA_GENOME_BROWSER = "data_genome_browser";
        private static final boolean DEFAULT_DATA_GENOME_BROWSER = true;
        public static final String GENOMEBROWSER = "genomebrowser";
        public static final String GENOMEBROWSER_INIT = "gb_init";
        public static final String GENOMEBROWSER_INIT_BROWSER_LINKS = "gb_init_browser_links";
        public static final String GENOMEBROWSER_INIT_COORD_SYSTEM = "gb_init_coord_system";
        public static final String GENOMEBROWSER_INIT_LOCATION = "gb_init_location";
        public static final String GENOMEBROWSER_INIT_SOURCES = "gb_init_sources";
        public static final String GENOMEBROWSER_INIT_HIGHLIGHT_REGION = "gb_init_highlight_region";
        private static final String DEFAULT_GENOMEBROWSER_INIT_BROWSER_LINKS = "{Ensembl: 'http://www.ensembl.org/Homo_sapiens/Location/View?r=${chr}:${start}-${end}',UCSC: 'http://genome.ucsc.edu/cgi-bin/hgTracks?db=hg19&position=chr${chr}:${start}-${end}',Sequence: 'http://www.derkholm.net:8080/das/hg19comp/sequence?segment=${chr}:${start},${end}'}";
        private static final String DEFAULT_GENOMEBROWSER_INIT_COORD_SYSTEM = "{speciesName: 'Human',taxon: 9606,auth: 'GRCh',version: '37',ucscName: 'hg19'}";
        private static final String DEFAULT_GENOMEBROWSER_INIT_LOCATION = "chr:'1',viewStart:10000000,viewEnd:10100000,cookieKey:'human',nopersist:true";
        private static final String DEFAULT_GENOMEBROWSER_INIT_SOURCES = "[{name:'Genome',twoBitURI:'//www.biodalliance.org/datasets/hg19.2bit',tier_type: 'sequence'},{name: 'Genes',desc: 'Gene structures from GENCODE 19',bwgURI: '//www.biodalliance.org/datasets/gencode.bb',stylesheet_uri: '//www.biodalliance.org/stylesheets/gencode.xml',collapseSuperGroups: true,trixURI:'//www.biodalliance.org/datasets/geneIndex.ix'},{name: 'Repeats',desc: 'Repeat annotation from Ensembl 59',bwgURI: '//www.biodalliance.org/datasets/repeats.bb',stylesheet_uri: '//www.biodalliance.org/stylesheets/bb-repeats.xml'},{name: 'Conservation',desc: 'Conservation',bwgURI: '//www.biodalliance.org/datasets/phastCons46way.bw',noDownsample: true}]";
        private static final boolean DEFAULT_GENOMEBROWSER_INIT_HIGHLIGHT_REGION = false;
        public static final String AGGREGATES = "aggregates";
        public static final String AGGREGATES_DISTINCT_SELECT = "agg_distinct";
        public static final String AGGREGATES_DISTINCT_OVERRIDES = "agg_distinct_overrides";
        public static final String REPORTS = "reports";
        public static final String REPORTS_ENTITIES = "reports_entities";
        private static final boolean DEFAULT_AGGREGATES_DISTINCT_SELECT = true;
        private static final boolean DEFAULT_SHOW_NAVIGATOR_LINK = true;
        private static final boolean DEFAULT_USE_VUE_DATA_ROW_EDIT = false;

        public Meta() {
            super(DataExplorerSettings.ID);
        }

        public void init() {
            super.init();
            this.setLabel("Data explorer settings");
            this.setDescription("Settings for the data explorer plugin.");
            this.addGeneralSettings();
            this.addModulesSettings();
        }

        private void addGeneralSettings() {
            Attribute generalAttr = this.addAttribute(GENERAL, new EntityType.AttributeRole[0]).setDataType(AttributeType.COMPOUND).setLabel("General");
            this.addAttribute(GENERAL_SEARCHBOX, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Show search box");
            this.addAttribute(GENERAL_ITEM_SELECT_PANEL, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Show data item selection");
            this.addAttribute(GENERAL_LAUNCH_WIZARD, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(false)).setLabel("Launch data item filter wizard");
            this.addAttribute(GENERAL_HEADER_ABBREVIATE, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.INT).setNillable(false).setDefaultValue(String.valueOf(180)).setLabel("Entity description abbreviation length");
            this.addAttribute(GENERAL_NAVIGATOR_LINK, new EntityType.AttributeRole[0]).setParent(generalAttr).setDataType(AttributeType.BOOL).setNillable(true).setDefaultValue(String.valueOf(true)).setLabel("Show a link to the navigator for the package of the selected entity");
        }

        private void addModulesSettings() {
            Attribute modAttr = this.addAttribute(MOD, new EntityType.AttributeRole[0]).setDataType(AttributeType.COMPOUND).setLabel("Modules");
            this.addAttribute(MOD_AGGREGATES, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Aggregates");
            this.createModAggregatesSettings(modAttr);
            this.addAttribute(MOD_DATA, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Data");
            this.createModDataSettings(modAttr);
            this.addAttribute(MOD_REPORTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Reports");
            this.addAttribute(MOD_STANDALONE_REPORTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(true).setDefaultValue(String.valueOf(false)).setLabel("Standalone Reports");
            this.createModReportSettings(modAttr);
        }

        private void createModDataSettings(Attribute modAttr) {
            Attribute dataAttr = this.addAttribute(DATA, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Data").setVisibleExpression("$('mod_data').eq(true).value()");
            Attribute genomeBrowserAttr = this.addAttribute(GENOMEBROWSER, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.COMPOUND).setLabel("Genome Browser").setVisibleExpression("$('data_genome_browser').eq(true).value()");
            Attribute genomeBrowserInitAttr = this.addAttribute(GENOMEBROWSER_INIT, new EntityType.AttributeRole[0]).setParent(genomeBrowserAttr).setDataType(AttributeType.COMPOUND).setLabel("Initialization");
            this.addAttribute(GENOMEBROWSER_INIT_BROWSER_LINKS, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_BROWSER_LINKS).setLabel("Browser links");
            this.addAttribute(GENOMEBROWSER_INIT_COORD_SYSTEM, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_COORD_SYSTEM).setLabel("Coordinate system");
            this.addAttribute(GENOMEBROWSER_INIT_LOCATION, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_LOCATION).setLabel("Location");
            this.addAttribute(GENOMEBROWSER_INIT_SOURCES, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.TEXT).setDefaultValue(DEFAULT_GENOMEBROWSER_INIT_SOURCES).setLabel("Sources");
            this.addAttribute(GENOMEBROWSER_INIT_HIGHLIGHT_REGION, new EntityType.AttributeRole[0]).setParent(genomeBrowserInitAttr).setNillable(false).setDataType(AttributeType.BOOL).setDefaultValue(String.valueOf(false)).setLabel("Highlight region");
            this.addAttribute(DATA_GENOME_BROWSER, new EntityType.AttributeRole[0]).setParent(dataAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Genome Browser");
            this.addAttribute(DATA_USE_VUE_ROW_EDIT, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(false)).setLabel("Edit the data row using the forms edit plugin.");
        }

        private void createModAggregatesSettings(Attribute modAttr) {
            Attribute aggregatesAttr = this.addAttribute(AGGREGATES, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Aggregates").setVisibleExpression("$('mod_aggregates').eq(true).value()");
            this.addAttribute(AGGREGATES_DISTINCT_SELECT, new EntityType.AttributeRole[0]).setParent(aggregatesAttr).setNillable(false).setDataType(AttributeType.BOOL).setDefaultValue(String.valueOf(true)).setLabel("Distinct aggregates");
            this.addAttribute(AGGREGATES_DISTINCT_OVERRIDES, new EntityType.AttributeRole[0]).setParent(aggregatesAttr).setDataType(AttributeType.TEXT).setLabel("Distinct attribute overrides").setDescription("JSON object that maps entity names to attribute names").setVisibleExpression("$('agg_distinct').eq(true).value()");
        }

        private void createModReportSettings(Attribute modAttr) {
            Attribute reportsAttr = this.addAttribute(REPORTS, new EntityType.AttributeRole[0]).setParent(modAttr).setDataType(AttributeType.COMPOUND).setLabel("Reports").setVisibleExpression("$('mod_reports').eq(true).value()");
            this.addAttribute(REPORTS_ENTITIES, new EntityType.AttributeRole[0]).setParent(reportsAttr).setNillable(true).setDataType(AttributeType.TEXT).setLabel("Reports").setDescription("Comma-seperated report strings (e.g. MyDataSet:myreport,OtherDataSet:otherreport). The report name refers to an existing FreemarkerTemplate entity or file with name view-<report>-entitiesreport.ftl (e.g. view-myreport-entitiesreport.ftl)");
        }
    }
}

