/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.decorator;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.molgenis.core.ui.data.system.core.FreemarkerTemplate;
import org.molgenis.data.decorator.PermissionChecker;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.dataexplorer.EntityTypeReportPermission;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.springframework.security.acls.model.ObjectIdentity;

public class EntityReportPermissionChecker
implements PermissionChecker<FreemarkerTemplate> {
    private static final Pattern ENTITY_REPORT_PATTERN = Pattern.compile("view-entityreport-specific-(.+)\\.ftl");
    private final UserPermissionEvaluator permissionEvaluator;

    EntityReportPermissionChecker(UserPermissionEvaluator permissionEvaluator) {
        this.permissionEvaluator = Objects.requireNonNull(permissionEvaluator);
    }

    public boolean isAddAllowed(FreemarkerTemplate freemarkerTemplate) {
        return this.hasEntityTypeReportPermission(freemarkerTemplate, EntityTypeReportPermission.MANAGE_REPORT);
    }

    public boolean isCountAllowed(FreemarkerTemplate freemarkerTemplate) {
        return this.isReadAllowed(freemarkerTemplate);
    }

    public boolean isReadAllowed(FreemarkerTemplate freemarkerTemplate) {
        return this.hasEntityTypeReportPermission(freemarkerTemplate, EntityTypeReportPermission.VIEW_REPORT);
    }

    public boolean isUpdateAllowed(FreemarkerTemplate freemarkerTemplate) {
        return this.hasEntityTypeReportPermission(freemarkerTemplate, EntityTypeReportPermission.MANAGE_REPORT);
    }

    public boolean isDeleteAllowed(FreemarkerTemplate freemarkerTemplate) {
        return this.hasEntityTypeReportPermission(freemarkerTemplate, EntityTypeReportPermission.MANAGE_REPORT);
    }

    private boolean hasEntityTypeReportPermission(FreemarkerTemplate freemarkerTemplate, EntityTypeReportPermission permission) {
        return EntityReportPermissionChecker.getEntityTypeId(freemarkerTemplate.getName()).map(EntityTypeIdentity::new).map(id -> this.permissionEvaluator.hasPermission((ObjectIdentity)id, (Permission)permission)).orElse(true);
    }

    private static Optional<String> getEntityTypeId(String templateName) {
        Matcher m = ENTITY_REPORT_PATTERN.matcher(templateName);
        if (m.matches()) {
            return Optional.of(m.group(1));
        }
        return Optional.empty();
    }
}

