/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import com.google.gson.Gson;
import freemarker.core.ParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.data.security.PackageIdentity;
import org.molgenis.data.security.PackagePermission;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.data.util.EntityUtils;
import org.molgenis.dataexplorer.controller.DataExplorerService;
import org.molgenis.dataexplorer.controller.DataRequest;
import org.molgenis.dataexplorer.controller.Module;
import org.molgenis.dataexplorer.controller.ModuleConfig;
import org.molgenis.dataexplorer.controller.ModulesConfigResponse;
import org.molgenis.dataexplorer.controller.NavigatorLink;
import org.molgenis.dataexplorer.download.DataExplorerDownloadHandler;
import org.molgenis.dataexplorer.negotiator.NegotiatorController;
import org.molgenis.dataexplorer.settings.DataExplorerSettings;
import org.molgenis.genomebrowser.GenomeBrowserTrack;
import org.molgenis.genomebrowser.service.GenomeBrowserService;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.settings.AppSettings;
import org.molgenis.util.UnexpectedEnumException;
import org.molgenis.util.stream.MapCollectors;
import org.molgenis.web.PluginController;
import org.molgenis.web.menu.MenuReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Controller
@RequestMapping(value={"/plugin/dataexplorer"})
public class DataExplorerController
extends PluginController {
    private static final Logger LOG = LoggerFactory.getLogger(DataExplorerController.class);
    public static final String ID = "dataexplorer";
    public static final String URI = "/plugin/dataexplorer";
    public static final String MOD_ENTITIESREPORT = "entitiesreport";
    public static final String MOD_DATA = "data";
    public static final String NAVIGATOR = "navigator";
    public static final String VIEW_NAME = "viewName";
    @Autowired
    private DataExplorerSettings dataExplorerSettings;
    @Autowired
    private NegotiatorController directoryController;
    @Autowired
    private DataService dataService;
    @Autowired
    private UserPermissionEvaluator permissionService;
    @Autowired
    private FreeMarkerConfigurer freemarkerConfigurer;
    @Autowired
    private Gson gson;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AttributeFactory attrMetaFactory;
    @Autowired
    private GenomeBrowserService genomeBrowserService;
    @Autowired
    private MenuReaderService menuReaderService;
    @Autowired
    private AppSettings appSettings;
    @Autowired
    private DataExplorerService dataExplorerService;

    public DataExplorerController() {
        super(URI);
    }

    @GetMapping
    public String init(@RequestParam(value="entity", required=false) String selectedEntityName, @RequestParam(value="entityId", required=false) String selectedEntityId, Model model) {
        StringBuilder message = new StringBuilder("");
        boolean currentUserIsSu = SecurityUtils.currentUserIsSu();
        Map entitiesMeta = (Map)this.dataService.getMeta().getEntityTypes().filter(entityType -> !entityType.isAbstract()).filter(entityType -> currentUserIsSu || !EntityTypeUtils.isSystemEntity((EntityType)entityType)).sorted(Comparator.comparing(EntityType::getLabel)).collect(MapCollectors.toLinkedMap(EntityType::getId, Function.identity()));
        model.addAttribute("entitiesMeta", (Object)entitiesMeta);
        if (selectedEntityId != null && selectedEntityName == null) {
            EntityType entityType2 = this.dataService.getMeta().getEntityType(selectedEntityId).orElse(null);
            if (entityType2 == null) {
                message.append("Entity does not exist or you do not have permission on this entity");
            } else {
                selectedEntityName = entityType2.getId();
            }
            if (selectedEntityName != null) {
                this.checkExistsAndPermission(selectedEntityName, message);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)message.toString())) {
            model.addAttribute("warningMessage", (Object)message.toString());
        }
        model.addAttribute("selectedEntityName", (Object)selectedEntityName);
        boolean navigatorAvailable = this.menuReaderService.findMenuItemPath(NAVIGATOR) != null;
        model.addAttribute("showNavigatorLink", (Object)(this.dataExplorerSettings.isShowNavigatorLink() && navigatorAvailable ? 1 : 0));
        model.addAttribute("hasTrackingId", (Object)(null != this.appSettings.getGoogleAnalyticsTrackingId() ? 1 : 0));
        model.addAttribute("hasMolgenisTrackingId", (Object)(null != this.appSettings.getGoogleAnalyticsTrackingIdMolgenis() ? 1 : 0));
        return "view-dataexplorer";
    }

    private void checkExistsAndPermission(@RequestParam(value="entity", required=false) String selectedEntityName, StringBuilder message) {
        boolean entityExists = this.dataService.hasRepository(selectedEntityName);
        boolean hasEntityPermission = this.permissionService.hasPermission((ObjectIdentity)new EntityTypeIdentity(selectedEntityName), (Permission)EntityTypePermission.READ_METADATA);
        if (!(entityExists && hasEntityPermission || selectedEntityName == null)) {
            message.append("Entity does not exist or you do not have permission on this entity");
            if (!SecurityUtils.currentUserIsAuthenticated()) {
                message.append(", log in to view more entities");
            } else {
                message.append(", please specify the fully qualified entity name");
            }
        }
    }

    @GetMapping(value={"/module/{moduleId}"})
    public String getModule(@PathVariable(value="moduleId") String moduleId, @RequestParam(value="entity") String entityTypeId, Model model) {
        switch (moduleId) {
            case "data": {
                EntityType selectedEntityType = this.dataService.getMeta().getEntityType(entityTypeId).orElse(null);
                Map entityTracks = this.genomeBrowserService.getGenomeBrowserTracks(selectedEntityType);
                model.addAttribute("genomeTracks", (Object)this.genomeBrowserService.getTracksString(entityTracks));
                if (!entityTracks.isEmpty()) {
                    GenomeBrowserTrack track = (GenomeBrowserTrack)entityTracks.entrySet().iterator().next().getValue();
                    model.addAttribute("pos_attr", (Object)track.getGenomeBrowserAttrs().getPos());
                    model.addAttribute("chrom_attr", (Object)track.getGenomeBrowserAttrs().getChrom());
                }
                model.addAttribute("showDirectoryButton", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("NegotiatorEnabled", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                break;
            }
            case "entitiesreport": {
                EntityType selectedEntityType = this.dataService.getMeta().getEntityType(entityTypeId).orElse(null);
                Map entityTracks = this.genomeBrowserService.getGenomeBrowserTracks(selectedEntityType);
                model.addAttribute("genomeTracks", (Object)this.genomeBrowserService.getTracksString(entityTracks));
                model.addAttribute("showDirectoryButton", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("NegotiatorEnabled", (Object)this.directoryController.showDirectoryButton(entityTypeId));
                model.addAttribute("datasetRepository", (Object)this.dataService.getRepository(entityTypeId));
                model.addAttribute(VIEW_NAME, (Object)this.dataExplorerSettings.getEntityReport(entityTypeId));
                break;
            }
        }
        return "view-dataexplorer-mod-" + moduleId;
    }

    @GetMapping(value={"/copy"})
    @ResponseBody
    public boolean showCopy(@RequestParam(value="entity") String entityTypeId) {
        boolean canReadData = this.permissionService.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityTypeId), (Permission)EntityTypePermission.READ_DATA);
        boolean repositoryIsWritable = this.dataService.getCapabilities(entityTypeId).contains(RepositoryCapability.WRITABLE);
        Package containingPackage = this.dataService.hasEntityType(entityTypeId) ? this.dataService.getEntityType(entityTypeId).getPackage() : null;
        boolean canAddEntityType = containingPackage != null && this.permissionService.hasPermission((ObjectIdentity)new PackageIdentity(containingPackage), (Permission)PackagePermission.ADD_ENTITY_TYPE);
        return canReadData && canAddEntityType && repositoryIsWritable;
    }

    @GetMapping(value={"/modules"})
    @ResponseBody
    public ModulesConfigResponse getModules(@RequestParam(value="entity") String entityTypeId) {
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        List<Module> modules = this.dataExplorerService.getModules(entityType);
        ModulesConfigResponse modulesConfigResponse = new ModulesConfigResponse();
        modules.forEach(module -> {
            String icon;
            String label;
            String id;
            switch (module) {
                case DATA: {
                    id = MOD_DATA;
                    label = "Data";
                    icon = "grid-icon.png";
                    break;
                }
                case AGGREGATION: {
                    id = "aggregates";
                    label = this.messageSource.getMessage("dataexplorer_aggregates_title", new Object[0], LocaleContextHolder.getLocale());
                    icon = "aggregate-icon.png";
                    break;
                }
                case REPORT: {
                    id = MOD_ENTITIESREPORT;
                    label = this.dataExplorerSettings.getEntityReport(entityTypeId);
                    icon = "report-icon.png";
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)module);
                }
            }
            modulesConfigResponse.add(new ModuleConfig(id, label, icon));
        });
        return modulesConfigResponse;
    }

    @GetMapping(value={"/navigatorLinks"})
    @ResponseBody
    public List<NavigatorLink> getNavigatorLinks(@RequestParam(value="entity") String entityTypeId) {
        LinkedList<NavigatorLink> result = new LinkedList<NavigatorLink>();
        EntityType entityType = this.dataService.hasEntityType(entityTypeId) ? this.dataService.getEntityType(entityTypeId) : null;
        String navigatorPath = this.menuReaderService.findMenuItemPath(NAVIGATOR);
        if (entityType != null) {
            Package pack = entityType.getPackage();
            this.getNavigatorLinks(result, pack, navigatorPath);
            result.add(NavigatorLink.create(navigatorPath + "/", "glyphicon-home"));
            Collections.reverse(result);
        }
        return result;
    }

    private void getNavigatorLinks(List<NavigatorLink> result, Package pack, String navigatorPath) {
        if (pack != null) {
            String label = pack.getLabel();
            String href = navigatorPath + "/" + pack.getId();
            result.add(NavigatorLink.create(href, label));
            pack = pack.getParent();
            this.getNavigatorLinks(result, pack, navigatorPath);
        }
    }

    @PostMapping(value={"/download"})
    public void download(@RequestParam(value="dataRequest") String dataRequestStr, HttpServletResponse response) throws IOException {
        DataExplorerDownloadHandler download = new DataExplorerDownloadHandler(this.dataService, this.attrMetaFactory);
        dataRequestStr = URLDecoder.decode(dataRequestStr, "UTF-8");
        dataRequestStr = dataRequestStr.replaceAll("[\n|\r|\t]", "_");
        LOG.info("Download request: [{}]", (Object)dataRequestStr);
        DataRequest dataRequest = (DataRequest)this.gson.fromJson(dataRequestStr, DataRequest.class);
        String fileName = this.getDownloadFilename(dataRequest.getEntityName(), LocalDateTime.now(), dataRequest.getDownloadType());
        switch (dataRequest.getDownloadType()) {
            case DOWNLOAD_TYPE_CSV: {
                response.setContentType("text/csv");
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                ServletOutputStream outputStream = response.getOutputStream();
                download.writeToCsv(dataRequest, (OutputStream)outputStream, ',');
                break;
            }
            case DOWNLOAD_TYPE_XLSX: {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                ServletOutputStream outputStream = response.getOutputStream();
                download.writeToExcel(dataRequest, (OutputStream)outputStream);
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)dataRequest.getDownloadType());
            }
        }
    }

    public String getDownloadFilename(String entityTypeId, LocalDateTime localDateTime, DataRequest.DownloadType downloadType) {
        String timestamp = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss"));
        return String.format("%s_%s.%s", entityTypeId, timestamp, downloadType == DataRequest.DownloadType.DOWNLOAD_TYPE_CSV ? "csv" : "xlsx");
    }

    @PostMapping(value={"/details"})
    public String viewEntityDetails(@RequestParam(value="entityTypeId") String entityTypeId, @RequestParam(value="entityId") String entityId, Model model) {
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        Object id = EntityUtils.getTypedValue((String)entityId, (Attribute)entityType.getIdAttribute());
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityTypeId).findOneById(id));
        model.addAttribute("entityType", (Object)entityType);
        model.addAttribute(VIEW_NAME, (Object)this.getEntityReportViewName(entityTypeId));
        model.addAttribute("showStandaloneReportUrl", (Object)this.dataExplorerSettings.getModStandaloneReports());
        model.addAttribute("entityTypeId", (Object)entityTypeId);
        model.addAttribute("entityId", (Object)entityId);
        return "view-entityreport";
    }

    @GetMapping(value={"/details/{entityTypeId}/{entityId}"})
    public String viewEntityDetailsById(@PathVariable(value="entityTypeId") String entityTypeId, @PathVariable(value="entityId") String entityId, Model model) {
        if (!this.dataService.hasEntityType(entityTypeId)) {
            throw new UnknownEntityTypeException(entityTypeId);
        }
        EntityType entityType = this.dataService.getEntityType(entityTypeId);
        Object id = EntityUtils.getTypedValue((String)entityId, (Attribute)entityType.getIdAttribute());
        model.addAttribute("entity", (Object)this.dataService.getRepository(entityTypeId).findOneById(id));
        model.addAttribute("entityType", (Object)entityType);
        model.addAttribute("entityTypeId", (Object)entityTypeId);
        model.addAttribute("entityTypeLabel", (Object)entityType.getLabel());
        model.addAttribute(VIEW_NAME, (Object)this.getStandaloneReportViewName(entityTypeId));
        return "view-standalone-report";
    }

    private String getEntityReportViewName(String entityTypeId) {
        String specificViewname;
        String reportTemplate = this.dataExplorerSettings.getEntityReport(entityTypeId);
        if (reportTemplate != null && this.viewExists(specificViewname = "view-entityreport-specific-" + reportTemplate)) {
            return specificViewname;
        }
        specificViewname = "view-entityreport-specific-" + entityTypeId;
        if (this.viewExists(specificViewname)) {
            return specificViewname;
        }
        if (this.viewExists("view-entityreport-generic")) {
            return "view-entityreport-generic";
        }
        return "view-entityreport-generic-default";
    }

    private String getStandaloneReportViewName(String entityTypeId) {
        String specificStandaloneReportViewName = "view-standalone-report-specific-" + entityTypeId;
        if (this.viewExists(specificStandaloneReportViewName)) {
            return specificStandaloneReportViewName;
        }
        return "view-standalone-report-default";
    }

    private boolean viewExists(String viewName) {
        try {
            return this.freemarkerConfigurer.getConfiguration().getTemplate(viewName + ".ftl") != null;
        }
        catch (ParseException e) {
            LOG.info("error parsing template: ", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

