package org.molgenis.dataexplorer.negotiator;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_NegotiatorRequest extends NegotiatorRequest {

  private final String URL;

  private final String entityId;

  private final String biobankId;

  private final String rsql;

  private final String biobankRsql;

  private final String humanReadable;

  private final String nToken;

  AutoValue_NegotiatorRequest(
      String URL,
      String entityId,
      @Nullable String biobankId,
      @Nullable String rsql,
      @Nullable String biobankRsql,
      String humanReadable,
      @Nullable String nToken) {
    if (URL == null) {
      throw new NullPointerException("Null URL");
    }
    this.URL = URL;
    if (entityId == null) {
      throw new NullPointerException("Null entityId");
    }
    this.entityId = entityId;
    this.biobankId = biobankId;
    this.rsql = rsql;
    this.biobankRsql = biobankRsql;
    if (humanReadable == null) {
      throw new NullPointerException("Null humanReadable");
    }
    this.humanReadable = humanReadable;
    this.nToken = nToken;
  }

  @Override
  public String getURL() {
    return URL;
  }

  @Override
  public String getEntityId() {
    return entityId;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getBiobankId() {
    return biobankId;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getRsql() {
    return rsql;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getBiobankRsql() {
    return biobankRsql;
  }

  @Override
  public String getHumanReadable() {
    return humanReadable;
  }

  @Nullable
  @CheckForNull
  @Override
  public String getnToken() {
    return nToken;
  }

  @Override
  public String toString() {
    return "NegotiatorRequest{"
         + "URL=" + URL + ", "
         + "entityId=" + entityId + ", "
         + "biobankId=" + biobankId + ", "
         + "rsql=" + rsql + ", "
         + "biobankRsql=" + biobankRsql + ", "
         + "humanReadable=" + humanReadable + ", "
         + "nToken=" + nToken
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof NegotiatorRequest) {
      NegotiatorRequest that = (NegotiatorRequest) o;
      return this.URL.equals(that.getURL())
          && this.entityId.equals(that.getEntityId())
          && (this.biobankId == null ? that.getBiobankId() == null : this.biobankId.equals(that.getBiobankId()))
          && (this.rsql == null ? that.getRsql() == null : this.rsql.equals(that.getRsql()))
          && (this.biobankRsql == null ? that.getBiobankRsql() == null : this.biobankRsql.equals(that.getBiobankRsql()))
          && this.humanReadable.equals(that.getHumanReadable())
          && (this.nToken == null ? that.getnToken() == null : this.nToken.equals(that.getnToken()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= URL.hashCode();
    h$ *= 1000003;
    h$ ^= entityId.hashCode();
    h$ *= 1000003;
    h$ ^= (biobankId == null) ? 0 : biobankId.hashCode();
    h$ *= 1000003;
    h$ ^= (rsql == null) ? 0 : rsql.hashCode();
    h$ *= 1000003;
    h$ ^= (biobankRsql == null) ? 0 : biobankRsql.hashCode();
    h$ *= 1000003;
    h$ ^= humanReadable.hashCode();
    h$ *= 1000003;
    h$ ^= (nToken == null) ? 0 : nToken.hashCode();
    return h$;
  }

}
