/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.dataexplorer.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.dataexplorer.EntityTypeReportPermission;
import org.molgenis.dataexplorer.controller.DataExplorerService;
import org.molgenis.dataexplorer.controller.Module;
import org.molgenis.dataexplorer.settings.DataExplorerSettings;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Service;

@Service
public class DataExplorerServiceImpl
implements DataExplorerService {
    private final DataExplorerSettings dataExplorerSettings;
    private final UserPermissionEvaluator userPermissionEvaluator;

    DataExplorerServiceImpl(DataExplorerSettings dataExplorerSettings, UserPermissionEvaluator userPermissionEvaluator) {
        this.dataExplorerSettings = Objects.requireNonNull(dataExplorerSettings);
        this.userPermissionEvaluator = Objects.requireNonNull(userPermissionEvaluator);
    }

    @Override
    public List<Module> getModules(EntityType entityType) {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Module module : Module.values()) {
            boolean includeModule;
            switch (module) {
                case DATA: {
                    includeModule = this.includeDataModule(entityType);
                    break;
                }
                case AGGREGATION: {
                    includeModule = this.includeAggregationModule(entityType);
                    break;
                }
                case REPORT: {
                    includeModule = this.includeReportModule(entityType);
                    break;
                }
                default: {
                    throw new UnexpectedEnumException((Enum)module);
                }
            }
            if (!includeModule) continue;
            modules.add(module);
        }
        return modules;
    }

    private boolean includeDataModule(EntityType entityType) {
        return this.dataExplorerSettings.getModData() && this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityType), (Permission)EntityTypePermission.READ_DATA);
    }

    private boolean includeAggregationModule(EntityType entityType) {
        return this.dataExplorerSettings.getModAggregates() && this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityType), (Permission)EntityTypePermission.AGGREGATE_DATA);
    }

    private boolean includeReportModule(EntityType entityType) {
        return this.dataExplorerSettings.getModReports() && this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity(entityType), (Permission)EntityTypeReportPermission.VIEW_REPORT) && this.dataExplorerSettings.getEntityReport(entityType.getId()) != null;
    }
}

