/* File:        org.molgenis/model/JDBCDatabase
 * Copyright:   Inventory 2000-2015, GBIC 2002-2015, all rights reserved
 * Date:        October 9, 2015
 * 
 * generator:   org.molgenis.generators.db.JDBCMetaDatabaseGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
package org.molgenis;

import java.lang.RuntimeException;
import java.util.Arrays;
import java.util.Vector;

import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Field;
import org.molgenis.model.MolgenisModelException;

/**
 * This class is an in memory representation of the contents of your *_db.xml file
 * Utility of this class is to allow for dynamic querying and/or user interfacing
 * for example within a query tool or a security module.
 */
public class JDBCMetaDatabase extends Model
{
	private static final long serialVersionUID = 1L;
	
	public JDBCMetaDatabase()
	{
		super("org.molgenis");
		try
		{
			//DiseaseMapping
			Entity diseaseMapping_entity = new Entity("DiseaseMapping",this.getDatabase());
			diseaseMapping_entity.setSystem(false);
			diseaseMapping_entity.setAbstract(false);
			diseaseMapping_entity.setDescription("Mapping of OMIM/ORPHANET diseases to HGNC genes to HPO terms.");
			diseaseMapping_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field diseaseMapping_id_field = new Field(diseaseMapping_entity, "id", MolgenisFieldTypes.getType("string"));
			diseaseMapping_id_field.setAuto(true);
			diseaseMapping_id_field.setDescription("automatically generated internal id, only for internal use");
			diseaseMapping_id_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_id_field);
			Field diseaseMapping_identifier_field = new Field(diseaseMapping_entity, "identifier", MolgenisFieldTypes.getType("string"));
			diseaseMapping_identifier_field.setDescription("Combination of diseaseId, geneSymbol and HPOId to get unique identifer");
			diseaseMapping_identifier_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_identifier_field);
			Field diseaseMapping_diseaseId_field = new Field(diseaseMapping_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			diseaseMapping_diseaseId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_diseaseId_field);
			Field diseaseMapping_geneSymbol_field = new Field(diseaseMapping_entity, "geneSymbol", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneSymbol_field.setDescription("Gene symbol");
			diseaseMapping_geneSymbol_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneSymbol_field);
			Field diseaseMapping_geneId_field = new Field(diseaseMapping_entity, "geneId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_geneId_field.setDescription("Entrez gene identifier");
			diseaseMapping_geneId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_geneId_field);
			Field diseaseMapping_hPOId_field = new Field(diseaseMapping_entity, "HPOId", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPOId_field.setDescription("HPO term identifier");
			diseaseMapping_hPOId_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPOId_field);
			Field diseaseMapping_hPODescription_field = new Field(diseaseMapping_entity, "HPODescription", MolgenisFieldTypes.getType("string"));
			diseaseMapping_hPODescription_field.setDescription("Description of the HPO term");
			diseaseMapping_hPODescription_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_hPODescription_field);
			Field diseaseMapping_isTypical_field = new Field(diseaseMapping_entity, "isTypical", MolgenisFieldTypes.getType("bool"));
			diseaseMapping_isTypical_field.setDescription("Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set");
			diseaseMapping_isTypical_field.setNillable(false);
			diseaseMapping_entity.addField(diseaseMapping_isTypical_field);
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			diseaseMapping_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
			//Disease
			Entity disease_entity = new Entity("Disease",this.getDatabase());
			disease_entity.setSystem(false);
			disease_entity.setAbstract(false);
			disease_entity.setDescription("Mapping of OMIM/ORPHANET disease id's to disease names.");
			disease_entity.setXrefLabels(Arrays.asList(new String[]{"identifier"}));
			Field disease_id_field = new Field(disease_entity, "id", MolgenisFieldTypes.getType("string"));
			disease_id_field.setAuto(true);
			disease_id_field.setDescription("automatically generated internal id, only for internal use");
			disease_id_field.setNillable(false);
			disease_entity.addField(disease_id_field);
			Field disease_identifier_field = new Field(disease_entity, "identifier", MolgenisFieldTypes.getType("string"));
			disease_identifier_field.setDescription("Combination of diseaseName, diseaseId and mappingMethod");
			disease_identifier_field.setNillable(false);
			disease_entity.addField(disease_identifier_field);
			Field disease_diseaseId_field = new Field(disease_entity, "diseaseId", MolgenisFieldTypes.getType("string"));
			disease_diseaseId_field.setDescription("OMIM or ORPHANET identifier");
			disease_diseaseId_field.setNillable(false);
			disease_entity.addField(disease_diseaseId_field);
			Field disease_diseaseName_field = new Field(disease_entity, "diseaseName", MolgenisFieldTypes.getType("string"));
			disease_diseaseName_field.setDescription("OMIM or ORPHANET disease name");
			disease_diseaseName_field.setNillable(false);
			disease_entity.addField(disease_diseaseName_field);
			Field disease_mappingMethod_field = new Field(disease_entity, "mappingMethod", MolgenisFieldTypes.getType("string"));
			disease_mappingMethod_field.setDescription("The phenotype mapping method");
			disease_mappingMethod_field.setNillable(false);
			disease_entity.addField(disease_mappingMethod_field);
			disease_entity.addKey(Arrays.asList(new String[]{"id"}),false,"");
			disease_entity.addKey(Arrays.asList(new String[]{"identifier"}),false,"");
			
		} catch (MolgenisModelException e)
		{
			throw new RuntimeException(e);
		}
	}
}