
/* File:        org.molgenis/model/DiseaseMapping.java
 * Generator:   org.molgenis.generators.DataTypeGen 4.0.0-testing
 *
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */
 

package org.molgenis.diseasemapping;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.support.MapEntity;
import org.molgenis.data.Entity;

/**
 * DiseaseMapping: Mapping of OMIM/ORPHANET diseases to HGNC genes to HPO terms..
 * 
 * @author MOLGENIS generator
 */
@javax.persistence.Entity
@javax.persistence.Table(name = "DiseaseMapping", uniqueConstraints={ @javax.persistence.UniqueConstraint( columnNames={ "identifier" } ) }
)

@javax.xml.bind.annotation.XmlAccessorType(javax.xml.bind.annotation.XmlAccessType.FIELD)
@edu.umd.cs.findbugs.annotations.SuppressWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="Exposing internal representation is accepted")

public class DiseaseMapping extends org.molgenis.data.support.AbstractEntity implements org.molgenis.data.Entity
{
    /** default serial version ID */
    private static final long serialVersionUID = 1L;
    
    public final static String ENTITY_NAME = "DiseaseMapping";
    
	// fieldname constants
	public final static String ID = "id";
	public final static String IDENTIFIER = "identifier";
	public final static String DISEASEID = "diseaseId";
	public final static String GENESYMBOL = "geneSymbol";
	public final static String GENEID = "geneId";
	public final static String HPOID = "HPOId";
	public final static String HPODESCRIPTION = "HPODescription";
	public final static String ISTYPICAL = "isTypical";
	
	// member variables (including setters.getters for interface)
	public String getEntityName()
	{
		return ENTITY_NAME;
	}
	

	//automatically generated internal id, only for internal use[type=string]
  				@javax.persistence.Id  

    @javax.persistence.Column(name="id", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="id")
	
	private String id =  null;

	//Combination of diseaseId, geneSymbol and HPOId to get unique identifer[type=string]

	@javax.persistence.Column(name="identifier", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="identifier")
	
				

	@javax.validation.constraints.NotNull
	private String identifier =  null;

	//OMIM or ORPHANET identifier[type=string]

	@javax.persistence.Column(name="diseaseId", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="diseaseId")
	
				

	@javax.validation.constraints.NotNull
	private String diseaseId =  null;

	//Gene symbol[type=string]

	@javax.persistence.Column(name="geneSymbol", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="geneSymbol")
	
				

	@javax.validation.constraints.NotNull
	private String geneSymbol =  null;

	//Entrez gene identifier[type=string]

	@javax.persistence.Column(name="geneId", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="geneId")
	
				

	@javax.validation.constraints.NotNull
	private String geneId =  null;

	//HPO term identifier[type=string]

	@javax.persistence.Column(name="HPOId", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="hPOId")
	
				

	@javax.validation.constraints.NotNull
	private String hPOId =  null;

	//Description of the HPO term[type=string]

	@javax.persistence.Column(name="HPODescription", length=255, nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="hPODescription")
	
				

	@javax.validation.constraints.NotNull
	private String hPODescription =  null;

	//Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set[type=bool]

	@javax.persistence.Column(name="isTypical", nullable=false)
	@javax.xml.bind.annotation.XmlElement(name="isTypical")
	
				

	@javax.validation.constraints.NotNull
	private Boolean isTypical =  null;

	//constructors
	public DiseaseMapping()
	{
	}
	
	//getters and setters
	/**
	 * Get the automatically generated internal id, only for internal use.
	 * @return id.
	 */
	public String getId()
	{
		return this.id;
	}
	
	
	/**
	 * Set the automatically generated internal id, only for internal use.
	 * @param id
	 */
	public void setId( String id)
	{
		this.id = id;
	}

	

	/**
	 * Get the Combination of diseaseId, geneSymbol and HPOId to get unique identifer.
	 * @return identifier.
	 */
	public String getIdentifier()
	{
		return this.identifier;
	}	
	
	/**
	 * Set the Combination of diseaseId, geneSymbol and HPOId to get unique identifer.
	 * @param identifier
	 */
	public void setIdentifier( String identifier)
	{
		
		this.identifier = identifier;
	}

	

	/**
	 * Get the OMIM or ORPHANET identifier.
	 * @return diseaseId.
	 */
	public String getDiseaseId()
	{
		return this.diseaseId;
	}	
	
	/**
	 * Set the OMIM or ORPHANET identifier.
	 * @param diseaseId
	 */
	public void setDiseaseId( String diseaseId)
	{
		
		this.diseaseId = diseaseId;
	}

	

	/**
	 * Get the Gene symbol.
	 * @return geneSymbol.
	 */
	public String getGeneSymbol()
	{
		return this.geneSymbol;
	}	
	
	/**
	 * Set the Gene symbol.
	 * @param geneSymbol
	 */
	public void setGeneSymbol( String geneSymbol)
	{
		
		this.geneSymbol = geneSymbol;
	}

	

	/**
	 * Get the Entrez gene identifier.
	 * @return geneId.
	 */
	public String getGeneId()
	{
		return this.geneId;
	}	
	
	/**
	 * Set the Entrez gene identifier.
	 * @param geneId
	 */
	public void setGeneId( String geneId)
	{
		
		this.geneId = geneId;
	}

	

	/**
	 * Get the HPO term identifier.
	 * @return hPOId.
	 */
	public String getHPOId()
	{
		return this.hPOId;
	}	
	
	/**
	 * Set the HPO term identifier.
	 * @param hPOId
	 */
	public void setHPOId( String hPOId)
	{
		
		this.hPOId = hPOId;
	}

	

	/**
	 * Get the Description of the HPO term.
	 * @return hPODescription.
	 */
	public String getHPODescription()
	{
		return this.hPODescription;
	}	
	
	/**
	 * Set the Description of the HPO term.
	 * @param hPODescription
	 */
	public void setHPODescription( String hPODescription)
	{
		
		this.hPODescription = hPODescription;
	}

	

	/**
	 * Get the Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set.
	 * @return isTypical.
	 */
	public Boolean getIsTypical()
	{
		return this.isTypical;
	}	
	
	/**
	 * Set the Boolean to indicate if this term is only found in the TYPICAL disease-gene-phenotype set.
	 * @param isTypical
	 */
	public void setIsTypical( Boolean isTypical)
	{
		
		this.isTypical = isTypical;
	}

	


	/**
	 * Generic getter. Get the property by using the name.
	 */
	@Override
	public Object get(String name)
	{
		name = name.toLowerCase();
		if (name.equals("id"))
			return getId();
		if (name.equals("identifier"))
			return getIdentifier();
		if (name.equals("diseaseid"))
			return getDiseaseId();
		if (name.equals("genesymbol"))
			return getGeneSymbol();
		if (name.equals("geneid"))
			return getGeneId();
		if (name.equals("hpoid"))
			return getHPOId();
		if (name.equals("hpodescription"))
			return getHPODescription();
		if (name.equals("istypical"))
			return getIsTypical();
		return null;
	}	
	
	@Override
	public void set(Entity entity)
	{
		set(entity, true);
	}

	public void set(org.molgenis.data.Entity entity, boolean strict)
	{
		//set Id
		// query formal name, else lowercase name
		if(entity.getString("id") != null) this.setId(entity.getString("id"));
		else if(entity.getString("id") != null) this.setId(entity.getString("id"));
		else if(strict) this.setId(entity.getString("id")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_id") != null) this.setId(entity.getString("diseasemapping_id"));
		else if( entity.getString("DiseaseMapping_id") != null) this.setId(entity.getString("DiseaseMapping_id"));
		//set Identifier
		// query formal name, else lowercase name
		if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(entity.getString("identifier") != null) this.setIdentifier(entity.getString("identifier"));
		else if(strict) this.setIdentifier(entity.getString("identifier")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_identifier") != null) this.setIdentifier(entity.getString("diseasemapping_identifier"));
		else if( entity.getString("DiseaseMapping_identifier") != null) this.setIdentifier(entity.getString("DiseaseMapping_identifier"));
		//set DiseaseId
		// query formal name, else lowercase name
		if(entity.getString("diseaseid") != null) this.setDiseaseId(entity.getString("diseaseid"));
		else if(entity.getString("diseaseId") != null) this.setDiseaseId(entity.getString("diseaseId"));
		else if(strict) this.setDiseaseId(entity.getString("diseaseid")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_diseaseid") != null) this.setDiseaseId(entity.getString("diseasemapping_diseaseid"));
		else if( entity.getString("DiseaseMapping_diseaseId") != null) this.setDiseaseId(entity.getString("DiseaseMapping_diseaseId"));
		//set GeneSymbol
		// query formal name, else lowercase name
		if(entity.getString("genesymbol") != null) this.setGeneSymbol(entity.getString("genesymbol"));
		else if(entity.getString("geneSymbol") != null) this.setGeneSymbol(entity.getString("geneSymbol"));
		else if(strict) this.setGeneSymbol(entity.getString("genesymbol")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_genesymbol") != null) this.setGeneSymbol(entity.getString("diseasemapping_genesymbol"));
		else if( entity.getString("DiseaseMapping_geneSymbol") != null) this.setGeneSymbol(entity.getString("DiseaseMapping_geneSymbol"));
		//set GeneId
		// query formal name, else lowercase name
		if(entity.getString("geneid") != null) this.setGeneId(entity.getString("geneid"));
		else if(entity.getString("geneId") != null) this.setGeneId(entity.getString("geneId"));
		else if(strict) this.setGeneId(entity.getString("geneid")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_geneid") != null) this.setGeneId(entity.getString("diseasemapping_geneid"));
		else if( entity.getString("DiseaseMapping_geneId") != null) this.setGeneId(entity.getString("DiseaseMapping_geneId"));
		//set HPOId
		// query formal name, else lowercase name
		if(entity.getString("hpoid") != null) this.setHPOId(entity.getString("hpoid"));
		else if(entity.getString("HPOId") != null) this.setHPOId(entity.getString("HPOId"));
		else if(strict) this.setHPOId(entity.getString("hpoid")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_hpoid") != null) this.setHPOId(entity.getString("diseasemapping_hpoid"));
		else if( entity.getString("DiseaseMapping_HPOId") != null) this.setHPOId(entity.getString("DiseaseMapping_HPOId"));
		//set HPODescription
		// query formal name, else lowercase name
		if(entity.getString("hpodescription") != null) this.setHPODescription(entity.getString("hpodescription"));
		else if(entity.getString("HPODescription") != null) this.setHPODescription(entity.getString("HPODescription"));
		else if(strict) this.setHPODescription(entity.getString("hpodescription")); // setting null is not an option due to function overloading
		if( entity.getString("diseasemapping_hpodescription") != null) this.setHPODescription(entity.getString("diseasemapping_hpodescription"));
		else if( entity.getString("DiseaseMapping_HPODescription") != null) this.setHPODescription(entity.getString("DiseaseMapping_HPODescription"));
		//set IsTypical
		// query formal name, else lowercase name
		if(entity.getBoolean("istypical") != null) this.setIsTypical(entity.getBoolean("istypical"));
		else if(entity.getBoolean("isTypical") != null) this.setIsTypical(entity.getBoolean("isTypical"));
		else if(strict) this.setIsTypical(entity.getBoolean("istypical")); // setting null is not an option due to function overloading
		if( entity.getBoolean("diseasemapping_istypical") != null) this.setIsTypical(entity.getBoolean("diseasemapping_istypical"));
		else if( entity.getBoolean("DiseaseMapping_isTypical") != null) this.setIsTypical(entity.getBoolean("DiseaseMapping_isTypical"));
	}
	
	@Override
	public String toString()
	{
		return this.toString(false);
	}
	
	public String toString(boolean verbose)
	{
		StringBuilder sb = new StringBuilder("DiseaseMapping(");
		sb.append("id='" + getId()+"' ");	
		sb.append("identifier='" + getIdentifier()+"' ");	
		sb.append("diseaseId='" + getDiseaseId()+"' ");	
		sb.append("geneSymbol='" + getGeneSymbol()+"' ");	
		sb.append("geneId='" + getGeneId()+"' ");	
		sb.append("hPOId='" + getHPOId()+"' ");	
		sb.append("hPODescription='" + getHPODescription()+"' ");	
		sb.append("isTypical='" + getIsTypical()+"'");	
		sb.append(");");
		return sb.toString();
	}

	@Override
	public String getIdValue()
	{
		return getId();
	}		
	

	@Override
	public Iterable<String> getAttributeNames()
	{
		Set<String> attributeNames = new LinkedHashSet<String>();
		for (AttributeMetaData attr : new DiseaseMappingMetaData().getAttributes())
		{
			attributeNames.add(attr.getName());
		}

		return attributeNames;
	}

	@Override
	public void set(String attributeName, Object value)
	{
		if("id".equalsIgnoreCase(attributeName)) {
			this.setId((String)value); 
			return;
		}
		if("identifier".equalsIgnoreCase(attributeName)) {
			this.setIdentifier((String)value); 
			return;
		}
		if("diseaseId".equalsIgnoreCase(attributeName)) {
			this.setDiseaseId((String)value); 
			return;
		}
		if("geneSymbol".equalsIgnoreCase(attributeName)) {
			this.setGeneSymbol((String)value); 
			return;
		}
		if("geneId".equalsIgnoreCase(attributeName)) {
			this.setGeneId((String)value); 
			return;
		}
		if("HPOId".equalsIgnoreCase(attributeName)) {
			this.setHPOId((String)value); 
			return;
		}
		if("HPODescription".equalsIgnoreCase(attributeName)) {
			this.setHPODescription((String)value); 
			return;
		}
		if("isTypical".equalsIgnoreCase(attributeName)) {
			this.setIsTypical((Boolean)value); 
			return;
		}
	}

	@Override
	public boolean equals(Object obj)
	{
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		DiseaseMapping other = (DiseaseMapping) obj;
		if (identifier == null)
		{
			if (other.identifier != null) return false;
		}
		else if (!identifier.equals(other.identifier)) return false;
		return true;
	}
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime * result + ((identifier == null) ? 0 : identifier.hashCode());
		return result;
	}
	
	@Override
	public org.molgenis.data.EntityMetaData getEntityMetaData()
	{
		return new DiseaseMappingMetaData();
	}
}
