/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.fair.controller;

import java.util.Objects;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.fair.controller.EntityModelWriter;
import org.molgenis.security.core.runas.RunAsSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/api/fdp"})
public class FairController {
    private static final Logger LOG = LoggerFactory.getLogger(FairController.class);
    static final String BASE_URI = "/api/fdp";
    private final DataService dataService;
    private final EntityModelWriter entityModelWriter;

    public FairController(DataService dataService, EntityModelWriter entityModelWriter) {
        this.dataService = Objects.requireNonNull(dataService);
        this.entityModelWriter = Objects.requireNonNull(entityModelWriter);
    }

    private static UriComponentsBuilder getBaseUri() {
        return ServletUriComponentsBuilder.fromCurrentContextPath().path(BASE_URI);
    }

    @GetMapping(produces={"text/turtle"})
    @ResponseBody
    @RunAsSystem
    public Model getMetadata() {
        String subjectIRI = FairController.getBaseUri().toUriString();
        Entity subjectEntity = this.dataService.findOne("fdp_Metadata", (Query)new QueryImpl());
        return this.entityModelWriter.createRdfModel(subjectIRI, subjectEntity);
    }

    @GetMapping(produces={"text/turtle"}, value={"/{catalogID}"})
    @ResponseBody
    @RunAsSystem
    public Model getCatalog(@PathVariable(value="catalogID") String catalogID) {
        String subjectIRI = FairController.getBaseUri().pathSegment(new String[]{catalogID}).toUriString();
        Entity subjectEntity = this.dataService.findOneById("fdp_Catalog", (Object)catalogID);
        if (subjectEntity == null) {
            throw new UnknownEntityException("fdp_Catalog", (Object)catalogID);
        }
        return this.entityModelWriter.createRdfModel(subjectIRI, subjectEntity);
    }

    @GetMapping(produces={"text/turtle"}, value={"/{catalogID}/{datasetID}"})
    @ResponseBody
    @RunAsSystem
    public Model getDataset(@PathVariable(value="catalogID") String catalogID, @PathVariable(value="datasetID") String datasetID) {
        String subjectIRI = FairController.getBaseUri().pathSegment(new String[]{catalogID, datasetID}).toUriString();
        Entity subjectEntity = this.dataService.findOneById("fdp_Dataset", (Object)datasetID);
        if (subjectEntity == null) {
            throw new UnknownEntityException("fdp_Dataset", (Object)datasetID);
        }
        return this.entityModelWriter.createRdfModel(subjectIRI, subjectEntity);
    }

    @GetMapping(produces={"text/turtle"}, value={"/{catalogID}/{datasetID}/{distributionID}"})
    @ResponseBody
    @RunAsSystem
    public Model getDistribution(@PathVariable(value="catalogID") String catalogID, @PathVariable(value="datasetID") String datasetID, @PathVariable(value="distributionID") String distributionID) {
        String subjectIRI = FairController.getBaseUri().pathSegment(new String[]{catalogID, datasetID, distributionID}).toUriString();
        Entity subjectEntity = this.dataService.findOneById("fdp_Distribution", (Object)distributionID);
        return this.entityModelWriter.createRdfModel(subjectIRI, subjectEntity);
    }

    @ExceptionHandler(value={UnknownEntityException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Model handleUnknownEntityException(UnknownEntityException e) {
        LOG.warn(e.getMessage(), (Throwable)e);
        return new LinkedHashModel();
    }
}

