/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import org.molgenis.data.AggregateQuery;
import org.molgenis.data.AggregateResult;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityListener;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.file.ingest.FileIngesterJobScheduler;

public class FileIngestRepositoryDecorator
implements Repository {
    private final Repository decorated;
    private final FileIngesterJobScheduler scheduler;
    private final DataService dataService;

    public FileIngestRepositoryDecorator(Repository decorated, FileIngesterJobScheduler scheduler, DataService dataService) {
        this.decorated = decorated;
        this.scheduler = scheduler;
        this.dataService = dataService;
    }

    public Iterator<Entity> iterator() {
        return this.decorated.iterator();
    }

    public void close() throws IOException {
        this.decorated.close();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return this.decorated.getCapabilities();
    }

    public String getName() {
        return this.decorated.getName();
    }

    public EntityMetaData getEntityMetaData() {
        return this.decorated.getEntityMetaData();
    }

    public long count() {
        return this.decorated.count();
    }

    public Query query() {
        return this.decorated.query();
    }

    public long count(Query q) {
        return this.decorated.count(q);
    }

    public Stream<Entity> findAll(Query q) {
        return this.decorated.findAll(q);
    }

    public Entity findOne(Query q) {
        return this.decorated.findOne(q);
    }

    public Entity findOne(Object id) {
        return this.decorated.findOne(id);
    }

    public Entity findOne(Object id, Fetch fetch) {
        return this.decorated.findOne(id, fetch);
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        return this.decorated.findAll(ids);
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        return this.decorated.findAll(ids, fetch);
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        return this.decorated.aggregate(aggregateQuery);
    }

    public void update(Entity entity) {
        this.decorated.update(entity);
        this.scheduler.schedule(entity);
    }

    public void update(Stream<? extends Entity> entities) {
        this.decorated.update(entities.filter(e -> {
            this.scheduler.schedule((Entity)e);
            return true;
        }));
    }

    private void removeJobExecutions(String entityId) {
        Query query = this.dataService.query("FileIngestJobExecution").eq("fileIngest", (Object)entityId);
        this.dataService.delete("FileIngestJobExecution", this.dataService.findAll("FileIngestJobExecution", query));
    }

    public void delete(Entity entity) {
        String entityId = entity.getString("id");
        this.scheduler.unschedule(entityId);
        this.removeJobExecutions(entityId);
        this.decorated.delete(entity);
    }

    public void delete(Stream<? extends Entity> entities) {
        this.decorated.delete(entities.filter(e -> {
            String entityId = e.getString("id");
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
            return true;
        }));
    }

    public void deleteById(Object id) {
        if (id instanceof String) {
            String entityId = (String)id;
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
        }
        this.decorated.deleteById(id);
    }

    public void deleteById(Stream<Object> ids) {
        this.decorated.deleteById(ids.filter(id -> {
            if (id instanceof String) {
                String entityId = (String)id;
                this.scheduler.unschedule(entityId);
                this.removeJobExecutions(entityId);
            }
            return true;
        }));
    }

    public void deleteAll() {
        Iterator<Entity> iterator = this.iterator();
        while (iterator.hasNext()) {
            Entity e = iterator.next();
            String entityId = e.getString("id");
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
        }
        this.decorated.deleteAll();
    }

    public void add(Entity entity) {
        this.decorated.add(entity);
        this.scheduler.schedule(entity);
    }

    public Integer add(Stream<? extends Entity> entities) {
        return this.decorated.add(entities.filter(e -> {
            this.scheduler.schedule((Entity)e);
            return true;
        }));
    }

    public void flush() {
        this.decorated.flush();
    }

    public void clearCache() {
        this.decorated.clearCache();
    }

    public void create() {
        this.decorated.create();
    }

    public void drop() {
        this.decorated.drop();
    }

    public void rebuildIndex() {
        this.decorated.rebuildIndex();
    }

    public void addEntityListener(EntityListener entityListener) {
        this.decorated.addEntityListener(entityListener);
    }

    public void removeEntityListener(EntityListener entityListener) {
        this.decorated.removeEntityListener(entityListener);
    }

    public Stream<Entity> stream(Fetch fetch) {
        return this.decorated.stream(fetch);
    }
}

