/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.meta;

import com.google.common.collect.ImmutableList;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.meta.EntityMetaDataMetaData;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.FieldType;
import org.springframework.stereotype.Component;

@Component
public class FileIngestMetaData
extends DefaultEntityMetaData {
    public static final String ENTITY_NAME = "FileIngest";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String URL = "url";
    public static final String LOADER = "loader";
    public static final String ENTITY_META_DATA = "entityMetaData";
    public static final String CRONEXPRESSION = "cronexpression";
    public static final String ACTIVE = "active";
    public static final String FAILURE_EMAIL = "failureEmail";
    public static final ImmutableList<String> LOADERS = ImmutableList.of((Object)"CSV");

    public FileIngestMetaData() {
        super(ENTITY_NAME);
        this.addAttribute(ID, new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_ID}).setAuto(true).setNillable(false);
        this.addAttribute(NAME, new EntityMetaData.AttributeRole[]{EntityMetaData.AttributeRole.ROLE_LABEL, EntityMetaData.AttributeRole.ROLE_LOOKUP}).setLabel("Name").setNillable(false);
        this.addAttribute(DESCRIPTION, new EntityMetaData.AttributeRole[0]).setDataType(MolgenisFieldTypes.TEXT).setLabel("Description").setNillable(true);
        this.addAttribute(URL, new EntityMetaData.AttributeRole[0]).setLabel("Url").setDescription("Url of the file to download.").setNillable(false);
        this.addAttribute(LOADER, new EntityMetaData.AttributeRole[0]).setDataType((FieldType)new EnumField()).setEnumOptions(LOADERS).setLabel("Loader type").setNillable(false);
        this.addAttribute(ENTITY_META_DATA, new EntityMetaData.AttributeRole[0]).setDataType(MolgenisFieldTypes.XREF).setRefEntity((EntityMetaData)EntityMetaDataMetaData.INSTANCE).setLabel("Target EntityMetaData").setNillable(false);
        this.addAttribute(CRONEXPRESSION, new EntityMetaData.AttributeRole[0]).setLabel("Cronexpression").setNillable(false).setValidationExpression("$('cronexpression').matches(/^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$/).value()");
        this.addAttribute(ACTIVE, new EntityMetaData.AttributeRole[0]).setDataType(MolgenisFieldTypes.BOOL).setLabel("Active").setNillable(false);
        this.addAttribute(FAILURE_EMAIL, new EntityMetaData.AttributeRole[0]).setDataType(MolgenisFieldTypes.EMAIL).setLabel("Failure email").setDescription("Leave blank if you don't want to receive emails if the jobs failed.").setNillable(true);
    }
}

