/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest;

import com.google.common.collect.Sets;
import java.util.Set;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.file.ingest.FileIngesterQuartzJob;
import org.molgenis.file.ingest.execution.FileIngestException;
import org.molgenis.file.ingest.meta.FileIngest;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class FileIngesterJobScheduler
implements ApplicationListener<ContextRefreshedEvent> {
    public static final String TRIGGER_GROUP = "fileingest";
    public static final String JOB_GROUP = "fileingest";
    private static final Logger LOG = LoggerFactory.getLogger(FileIngesterJobScheduler.class);
    private final Scheduler scheduler;
    private final DataService dataService;

    @Autowired
    public FileIngesterJobScheduler(Scheduler scheduler, DataService dataService) {
        this.scheduler = scheduler;
        this.dataService = dataService;
    }

    public synchronized void runNow(String fileIngestId) {
        FileIngest fileIngest = (FileIngest)this.dataService.findOne("FileIngest", (Object)fileIngestId, FileIngest.class);
        if (fileIngest == null) {
            throw new UnknownEntityException("Unknown FileIngest entity id '" + fileIngestId + "'");
        }
        try {
            JobKey jobKey = new JobKey(fileIngestId, "fileingest");
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.triggerJob(jobKey);
            } else {
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(fileIngestId, "fileingest").startNow().build();
                this.schedule(fileIngestId, trigger);
            }
        }
        catch (SchedulerException e) {
            LOG.error("Error runNow FileIngesterJob", (Throwable)e);
            throw new FileIngestException("Error job runNow", e);
        }
    }

    public synchronized void schedule(Entity fileIngest) {
        String id = fileIngest.getString("id");
        String cronExpression = fileIngest.getString("cronexpression");
        String name = fileIngest.getString("name");
        if (!CronExpression.isValidExpression((String)cronExpression)) {
            throw new MolgenisValidationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{new ConstraintViolation("Invalid cronexpression '" + cronExpression + "'", null)}));
        }
        try {
            if (this.scheduler.checkExists(new JobKey(id, "fileingest"))) {
                this.unschedule(id);
            }
            if (!fileIngest.getBoolean("active").booleanValue()) {
                return;
            }
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(id, "fileingest").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
            this.schedule(fileIngest.getIdValue().toString(), trigger);
            LOG.info("Scheduled FileIngesterJob '{}' with trigger '{}'", (Object)name, (Object)trigger);
        }
        catch (SchedulerException e) {
            LOG.error("Error schedule job", (Throwable)e);
            throw new FileIngestException("Error schedule job", e);
        }
    }

    public synchronized void unschedule(String fileIngestId) {
        try {
            this.scheduler.deleteJob(new JobKey(fileIngestId, "fileingest"));
        }
        catch (SchedulerException e) {
            LOG.error("Error unschedule FileIngesterJob '" + fileIngestId + "'", (Throwable)e);
            throw new FileIngestException("Error unscheduling job", e);
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        RunAsSystemProxy.runAsSystem(() -> this.dataService.findAll("FileIngest", FileIngest.class).forEach(this::schedule));
    }

    private void schedule(String id, Trigger trigger) throws SchedulerException {
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("entity", id);
        JobDetail job = JobBuilder.newJob(FileIngesterQuartzJob.class).withIdentity(id, "fileingest").usingJobData(jobDataMap).build();
        this.scheduler.scheduleJob(job, trigger);
    }
}

