/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest;

import java.util.Iterator;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.file.ingest.FileIngesterJobScheduler;

public class FileIngestRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private final Repository<Entity> decorated;
    private final FileIngesterJobScheduler scheduler;
    private final DataService dataService;

    public FileIngestRepositoryDecorator(Repository<Entity> decorated, FileIngesterJobScheduler scheduler, DataService dataService) {
        this.decorated = decorated;
        this.scheduler = scheduler;
        this.dataService = dataService;
    }

    protected Repository<Entity> delegate() {
        return this.decorated;
    }

    public void update(Entity entity) {
        this.decorated.update(entity);
        this.scheduler.schedule(entity);
    }

    public void update(Stream<Entity> entities) {
        this.decorated.update(entities.filter(e -> {
            this.scheduler.schedule((Entity)e);
            return true;
        }));
    }

    public void delete(Entity entity) {
        String entityId = entity.getString("id");
        this.scheduler.unschedule(entityId);
        this.removeJobExecutions(entityId);
        this.decorated.delete(entity);
    }

    public void delete(Stream<Entity> entities) {
        this.decorated.delete(entities.filter(e -> {
            String entityId = e.getString("id");
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
            return true;
        }));
    }

    public void deleteById(Object id) {
        if (id instanceof String) {
            String entityId = (String)id;
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
        }
        this.decorated.deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        this.decorated.deleteAll(ids.filter(id -> {
            if (id instanceof String) {
                String entityId = (String)id;
                this.scheduler.unschedule(entityId);
                this.removeJobExecutions(entityId);
            }
            return true;
        }));
    }

    public void deleteAll() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Entity e = (Entity)iterator.next();
            String entityId = e.getString("id");
            this.scheduler.unschedule(entityId);
            this.removeJobExecutions(entityId);
        }
        this.decorated.deleteAll();
    }

    public void add(Entity entity) {
        this.decorated.add(entity);
        this.scheduler.schedule(entity);
    }

    public Integer add(Stream<Entity> entities) {
        return this.decorated.add(entities.filter(e -> {
            this.scheduler.schedule((Entity)e);
            return true;
        }));
    }

    private void removeJobExecutions(String entityId) {
        Query query = this.dataService.query("sys_FileIngestJobExecution").eq("fileIngest", (Object)entityId);
        this.dataService.delete("sys_FileIngestJobExecution", this.dataService.findAll("sys_FileIngestJobExecution", query));
    }
}

