/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.execution;

import java.io.File;
import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.FileRepositoryCollectionFactory;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.importer.EntityImportReport;
import org.molgenis.data.importer.ImportService;
import org.molgenis.data.importer.ImportServiceFactory;
import org.molgenis.data.jobs.Progress;
import org.molgenis.data.support.FileRepositoryCollection;
import org.molgenis.file.ingest.execution.FileIngestException;
import org.molgenis.file.ingest.execution.FileStoreDownload;
import org.molgenis.file.ingest.meta.FileIngestJobExecution;
import org.molgenis.file.model.FileMeta;
import org.molgenis.file.model.FileMetaFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileIngester {
    private final FileStoreDownload fileStoreDownload;
    private final ImportServiceFactory importServiceFactory;
    private final FileRepositoryCollectionFactory fileRepositoryCollectionFactory;
    private final FileMetaFactory fileMetaFactory;
    private final DataService dataService;

    @Autowired
    public FileIngester(FileStoreDownload fileStoreDownload, ImportServiceFactory importServiceFactory, FileRepositoryCollectionFactory fileRepositoryCollectionFactory, FileMetaFactory fileMetaFactory, DataService dataService) {
        this.fileStoreDownload = Objects.requireNonNull(fileStoreDownload);
        this.importServiceFactory = Objects.requireNonNull(importServiceFactory);
        this.fileRepositoryCollectionFactory = Objects.requireNonNull(fileRepositoryCollectionFactory);
        this.fileMetaFactory = Objects.requireNonNull(fileMetaFactory);
        this.dataService = dataService;
    }

    public FileMeta ingest(String entityName, String url, String loader, String jobExecutionID, Progress progress, String failureEmail) {
        if (!"CSV".equals(loader)) {
            throw new FileIngestException("Unknown loader '" + loader + "'");
        }
        progress.setProgressMax(2);
        progress.progress(0, "Downloading url '" + url + "'");
        File file = this.fileStoreDownload.downloadFile(url, jobExecutionID, entityName + ".csv");
        progress.progress(1, "Importing...");
        FileRepositoryCollection repoCollection = this.fileRepositoryCollectionFactory.createFileRepositoryCollection(file);
        ImportService importService = this.importServiceFactory.getImportService(file, (RepositoryCollection)repoCollection);
        EntityImportReport report = importService.doImport((RepositoryCollection)repoCollection, DatabaseAction.ADD_UPDATE_EXISTING, "base");
        progress.status("Ingestion of url '" + url + "' done.");
        Integer count = (Integer)report.getNrImportedEntitiesMap().get(entityName);
        count = count != null ? count : 0;
        progress.progress(2, "Successfully imported " + count + " " + entityName + " entities.");
        FileMeta fileMeta = this.createFileMeta(jobExecutionID, file);
        FileIngestJobExecution fileIngestJobExecution = (FileIngestJobExecution)progress.getJobExecution();
        fileIngestJobExecution.setFile(fileMeta);
        this.dataService.add("sys_FileMeta", (Entity)fileMeta);
        return fileMeta;
    }

    private FileMeta createFileMeta(String jobExecutionID, File file) {
        FileMeta fileMeta = (FileMeta)this.fileMetaFactory.create((Object)jobExecutionID);
        fileMeta.setContentType("text/csv");
        fileMeta.setSize(Long.valueOf(file.length()));
        fileMeta.setFilename(jobExecutionID + '/' + file.getName());
        fileMeta.setUrl("/files/" + jobExecutionID);
        return fileMeta;
    }
}

