/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.molgenis.data.DataService;
import org.molgenis.file.ingest.execution.FileIngestJob;
import org.molgenis.file.ingest.execution.FileIngestJobFactory;
import org.molgenis.file.ingest.meta.FileIngest;
import org.molgenis.file.ingest.meta.FileIngestJobExecution;
import org.molgenis.file.ingest.meta.FileIngestJobExecutionFactory;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@DisallowConcurrentExecution
public class FileIngesterQuartzJob
implements Job {
    public static final String ENTITY_KEY = "entity";
    private static final Logger LOG = LoggerFactory.getLogger(FileIngesterQuartzJob.class);
    @Autowired
    private FileIngestJobFactory fileIngestJobFactory;
    @Autowired
    private FileIngestJobExecutionFactory fileIngestJobExecutionFactory;
    @Autowired
    private DataService dataService;

    public FileIngesterQuartzJob() {
    }

    public FileIngesterQuartzJob(FileIngestJobFactory fileIngestJobFactory, DataService dataService) {
        this.fileIngestJobFactory = fileIngestJobFactory;
        this.dataService = dataService;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        Object fileIngestId = context.getMergedJobDataMap().get((Object)ENTITY_KEY);
        RunAsSystemProxy.runAsSystem(() -> this.run(fileIngestId));
    }

    private void run(Object fileIngestId) {
        FileIngest fileIngest = (FileIngest)this.dataService.findOneById("sys_FileIngest", fileIngestId, FileIngest.class);
        FileIngestJobExecution jobExecution = (FileIngestJobExecution)this.fileIngestJobExecutionFactory.create();
        jobExecution.setUser("admin");
        jobExecution.setFileIngest(fileIngest);
        jobExecution.setFailureEmail(fileIngest.getFailureEmail());
        try {
            jobExecution.setResultUrl("/menu/main/dataexplorer?entity=" + URLEncoder.encode(fileIngest.getTargetEntityName(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("UTF-8 not supported by URLEncoder", (Throwable)ex);
        }
        FileIngestJob job = this.fileIngestJobFactory.createJob(jobExecution);
        job.call();
    }
}

