/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.execution;

import java.util.Objects;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.jobs.JobExecutionUpdater;
import org.molgenis.data.jobs.Progress;
import org.molgenis.data.jobs.ProgressImpl;
import org.molgenis.data.jobs.model.JobExecution;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.file.ingest.execution.FileIngestJob;
import org.molgenis.file.ingest.execution.FileIngester;
import org.molgenis.file.ingest.meta.FileIngestJobExecution;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailSender;
import org.springframework.security.access.intercept.RunAsUserToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class FileIngestJobFactory {
    private final DataService dataService;
    private final UserDetailsService userDetailsService;
    private final JobExecutionUpdater jobExecutionUpdater;
    private final PlatformTransactionManager transactionManager;
    private final FileIngester fileIngester;
    private final MailSender mailSender;

    @Autowired
    public FileIngestJobFactory(DataService dataService, UserDetailsService userDetailsService, JobExecutionUpdater jobExecutionUpdater, PlatformTransactionManager transactionManager, FileIngester fileIngester, MailSender mailSender) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userDetailsService = Objects.requireNonNull(userDetailsService);
        this.jobExecutionUpdater = Objects.requireNonNull(jobExecutionUpdater);
        this.transactionManager = Objects.requireNonNull(transactionManager);
        this.fileIngester = Objects.requireNonNull(fileIngester);
        this.mailSender = Objects.requireNonNull(mailSender);
    }

    @RunAsSystem
    public FileIngestJob createJob(FileIngestJobExecution fileIngestJobExecution) {
        this.dataService.add("sys_FileIngestJobExecution", (Entity)fileIngestJobExecution);
        String username = fileIngestJobExecution.getUser();
        ProgressImpl progress = new ProgressImpl((JobExecution)fileIngestJobExecution, this.jobExecutionUpdater, this.mailSender);
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        RunAsUserToken runAsAuthentication = new RunAsUserToken("Job Execution", (Object)username, null, this.userDetailsService.loadUserByUsername(username).getAuthorities(), null);
        Entity fileIngestEntity = fileIngestJobExecution.getFileIngest();
        EntityType targetEntityEntity = (EntityType)fileIngestEntity.getEntity("entityType", EntityType.class);
        String targetEntityName = targetEntityEntity.getFullyQualifiedName();
        String url = fileIngestEntity.getString("url");
        String loader = fileIngestEntity.getString("loader");
        String failureEmail = fileIngestEntity.getString("failureEmail");
        return new FileIngestJob((Progress)progress, transactionTemplate, (Authentication)runAsAuthentication, this.fileIngester, targetEntityName, url, loader, failureEmail, fileIngestJobExecution.getIdentifier());
    }
}

