/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.text.MessageFormat;
import java.util.Objects;
import org.molgenis.data.jobs.Job;
import org.molgenis.data.jobs.JobFactory;
import org.molgenis.data.jobs.model.ScheduledJobType;
import org.molgenis.data.jobs.model.ScheduledJobTypeFactory;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.file.ingest.execution.FileIngester;
import org.molgenis.file.ingest.meta.FileIngestJobExecution;
import org.molgenis.file.ingest.meta.FileIngestJobExecutionMetaData;
import org.molgenis.ui.menu.MenuReaderService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Configuration
@Import(value={FileIngester.class})
public class FileIngestConfig {
    private final FileIngester fileIngester;
    private final ScheduledJobTypeFactory scheduledJobTypeFactory;
    private final FileIngestJobExecutionMetaData fileIngestJobExecutionMetaData;
    private final MenuReaderService menuReaderService;
    private final Gson gson;

    public FileIngestConfig(FileIngester fileIngester, ScheduledJobTypeFactory scheduledJobTypeFactory, FileIngestJobExecutionMetaData fileIngestJobExecutionMetaData, MenuReaderService menuReaderService, Gson gson) {
        this.fileIngester = Objects.requireNonNull(fileIngester);
        this.scheduledJobTypeFactory = Objects.requireNonNull(scheduledJobTypeFactory);
        this.fileIngestJobExecutionMetaData = Objects.requireNonNull(fileIngestJobExecutionMetaData);
        this.menuReaderService = Objects.requireNonNull(menuReaderService);
        this.gson = Objects.requireNonNull(gson);
    }

    @Bean
    public JobFactory<FileIngestJobExecution> fileIngestJobFactory() {
        return new JobFactory<FileIngestJobExecution>(){

            public Job createJob(FileIngestJobExecution fileIngestJobExecution) {
                String targetEntityId = fileIngestJobExecution.getTargetEntityId();
                String url = fileIngestJobExecution.getUrl();
                String loader = fileIngestJobExecution.getLoader();
                String dataExplorerURL = FileIngestConfig.this.menuReaderService.getMenu().findMenuItemPath("dataexplorer");
                fileIngestJobExecution.setResultUrl(MessageFormat.format("{0}?entity={1}", dataExplorerURL, targetEntityId));
                return progress -> FileIngestConfig.this.fileIngester.ingest(targetEntityId, url, loader, fileIngestJobExecution.getIdentifier(), progress);
            }
        };
    }

    @Lazy
    @Bean
    public ScheduledJobType fileIngestJobType() {
        ScheduledJobType result = (ScheduledJobType)this.scheduledJobTypeFactory.create((Object)"fileIngest");
        result.setLabel("File ingest");
        result.setDescription("This job downloads a file from a URL and imports it into MOLGENIS.");
        result.setSchema(this.gson.toJson((Object)ImmutableMap.of((Object)"title", (Object)"FileIngest Job", (Object)"type", (Object)"object", (Object)"properties", (Object)ImmutableMap.of((Object)"url", (Object)ImmutableMap.of((Object)"type", (Object)"string", (Object)"format", (Object)"uri", (Object)"description", (Object)"URL to download the file to ingest from"), (Object)"loader", (Object)ImmutableMap.of((Object)"enum", (Object)ImmutableList.of((Object)"CSV"), (Object)"description", (Object)"Loader used to ingest the file"), (Object)"targetEntityId", (Object)ImmutableMap.of((Object)"type", (Object)"string", (Object)"description", (Object)"ID of the entity to import to")), (Object)"required", (Object)ImmutableList.of((Object)"url", (Object)"loader", (Object)"targetEntityId"))));
        result.setJobExecutionType((EntityType)this.fileIngestJobExecutionMetaData);
        return result;
    }
}

