/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import org.molgenis.file.FileStore;
import org.molgenis.file.ingest.execution.FileStoreDownload;
import org.springframework.stereotype.Component;

@Component
public class FileStoreDownloadImpl
implements FileStoreDownload {
    private final FileStore fileStore;

    public FileStoreDownloadImpl(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    @Override
    public File downloadFile(String url, String folderName, String fileName) {
        try {
            File folder = new File(this.fileStore.getStorageDir(), folderName);
            folder.mkdir();
            InputStream in = new URL(url).openStream();
            String filename = folderName + '/' + fileName;
            return this.fileStore.store(in, filename);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

