/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.file.ingest.execution;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import org.molgenis.data.file.FileStore;
import org.molgenis.file.ingest.execution.FileStoreDownload;
import org.springframework.stereotype.Component;

@Component
public class FileStoreDownloadImpl
implements FileStoreDownload {
    private final FileStore fileStore;

    public FileStoreDownloadImpl(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    @Override
    public File downloadFile(String url, String folderName, String fileName) {
        File file;
        block8: {
            File folder = new File(this.fileStore.getStorageDir(), folderName);
            folder.mkdir();
            InputStream in = new URL(url).openStream();
            try {
                String filename = folderName + '/' + fileName;
                file = this.fileStore.store(in, filename);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return file;
    }
}

