/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser.meta;

import java.util.Arrays;
import java.util.Objects;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.AttributeMetadata;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.meta.model.Package;
import org.molgenis.genomebrowser.meta.GenomeBrowserAttributesMetadata;
import org.molgenis.genomebrowser.meta.GenomeBrowserPackage;
import org.springframework.stereotype.Component;

@Component
public class GenomeBrowserSettingsMetadata
extends SystemEntityType {
    public static final String SIMPLE_NAME = "GenomeBrowserSettings";
    public static final String GENOMEBROWSERSETTINGS = "sys_genomebrowser_GenomeBrowserSettings";
    public static final String IDENTIFIER = "id";
    public static final String LABEL = "label";
    public static final String LABEL_ATTR = "labelAttr";
    public static final String ENTITY = "entity";
    public static final String TRACK_TYPE = "track_type";
    public static final String MOLGENIS_REFERENCE_TRACKS = "molgenis_reference_tracks";
    public static final String MOLGENIS_REFERENCES_MODE = "molgenis_reference_tracks_mode";
    public static final String GENOME_BROWSER_ATTRS = "genome_browser_attrs";
    public static final String ACTIONS = "actions";
    public static final String ATTRS = "attrs";
    public static final String SCORE_ATTR = "scoreAttr";
    public static final String EXON_KEY = "exon_key";
    public static final String NUMERIC = "NUMERIC";
    public static final String EXON = "EXON";
    public static final String VARIANT = "VARIANT";
    public static final String ALL = "ALL";
    public static final String CONFIGURED = "CONFIGURED";
    public static final String NONE = "NONE";
    private final GenomeBrowserPackage genomeBrowserPackage;
    private EntityTypeMetadata entityTypeMetadata;
    private AttributeMetadata attributeMetadata;
    private GenomeBrowserAttributesMetadata genomeBrowserAttributesMetadata;

    public GenomeBrowserSettingsMetadata(AttributeMetadata attributeMetadata, EntityTypeMetadata entityTypeMetadata, GenomeBrowserAttributesMetadata genomeBrowserAttributesMetadata, GenomeBrowserPackage genomeBrowserPackage) {
        super(SIMPLE_NAME, "sys_genomebrowser");
        this.entityTypeMetadata = Objects.requireNonNull(entityTypeMetadata);
        this.attributeMetadata = Objects.requireNonNull(attributeMetadata);
        this.genomeBrowserAttributesMetadata = Objects.requireNonNull(genomeBrowserAttributesMetadata);
        this.genomeBrowserPackage = genomeBrowserPackage;
    }

    protected void init() {
        this.setLabel("Genome Browser Settings");
        this.setPackage((Package)this.genomeBrowserPackage);
        this.addAttribute(IDENTIFIER, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setLabel("Identifier").setAuto(true).setNillable(false);
        this.addAttribute(LABEL, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_LABEL}).setLabel("Label").setNillable(false);
        this.addAttribute(ENTITY, new EntityType.AttributeRole[0]).setLabel("Entity").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.entityTypeMetadata).setNillable(false);
        this.addAttribute(GENOME_BROWSER_ATTRS, new EntityType.AttributeRole[0]).setLabel("Genomic attributes").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.genomeBrowserAttributesMetadata).setNillable(false).setDescription("Reference to the Genome Browser Attributes entity to tell the genome browser which attributes should be used for chromosome, positions, reference allele and alternative allele");
        this.addAttribute(LABEL_ATTR, new EntityType.AttributeRole[0]).setLabel("Label Attribute").setDataType(AttributeType.XREF).setRefEntity((EntityType)this.attributeMetadata).setNillable(false);
        this.addAttribute(TRACK_TYPE, new EntityType.AttributeRole[0]).setLabel("Track type").setDataType(AttributeType.ENUM).setEnumOptions(Arrays.asList(VARIANT, NUMERIC, EXON)).setNillable(false).setDescription("The track type which determines how dalliance will render the track");
        this.addAttribute(EXON_KEY, new EntityType.AttributeRole[0]).setLabel("Exon/intron key").setDescription("Value to distinguish Exon and intron values, if the key is present in the label attributes we assume this is an exon").setVisibleExpression("$('track_type').eq('EXON').value()");
        this.addAttribute(SCORE_ATTR, new EntityType.AttributeRole[0]).setLabel("Score attributes").setDescription("Name of the attribute that can be used for the score").setVisibleExpression("$('track_type').eq('NUMERIC').value()");
        this.addAttribute(ATTRS, new EntityType.AttributeRole[0]).setLabel("Feature popup attributes").setDescription("Comma separated list of label:attr pairs that should be shown in the genome browser popup, example: \"'Reference Allele:REF,Alternative Allele:ALT'\"");
        this.addAttribute(MOLGENIS_REFERENCES_MODE, new EntityType.AttributeRole[0]).setLabel("Reference track mode").setDataType(AttributeType.ENUM).setEnumOptions(Arrays.asList(ALL, CONFIGURED, NONE)).setNillable(false).setDescription("Setting to determine if all suitable molgenis entities should be shown as reference track in the genomebrowser, only those configured, or none");
        this.addAttribute(MOLGENIS_REFERENCE_TRACKS, new EntityType.AttributeRole[0]).setLabel("Reference tracks").setDataType(AttributeType.MREF).setRefEntity((EntityType)this).setVisibleExpression("$('molgenis_reference_tracks_mode').eq('CONFIGURED').value()").setDescription("the genome browser settings that should be shown as reference tracks");
        this.addAttribute(ACTIONS, new EntityType.AttributeRole[0]).setLabel("Actions").setDataType(AttributeType.TEXT).setDescription("a javascript array containing object that specify actions to be available in the genome browser popup, format: [{label:\"action1\" run:\"alert('action1')\"},{label:\"action2\" run:\"alert('action2')\"}]");
    }
}

