/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser.meta;

import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.genomebrowser.meta.GenomeBrowserPackage;
import org.springframework.stereotype.Component;

@Component
public class GenomeBrowserAttributesMetadata
extends SystemEntityType {
    public static final String SIMPLE_NAME = "GenomeBrowserAttributes";
    public static final String GENOMEBROWSERATTRIBUTES = "sys_genomebrowser_GenomeBrowserAttributes";
    public static final String IDENTIFIER = "id";
    public static final String DEFAULT = "default";
    public static final String ORDER = "order";
    public static final String POS = "pos";
    public static final String CHROM = "chr";
    public static final String REF = "ref";
    public static final String ALT = "alt";
    public static final String STOP = "stop";
    private final GenomeBrowserPackage genomeBrowserPackage;

    public GenomeBrowserAttributesMetadata(GenomeBrowserPackage genomeBrowserPackage) {
        super(SIMPLE_NAME, "sys_genomebrowser");
        this.genomeBrowserPackage = genomeBrowserPackage;
    }

    protected void init() {
        this.setLabel("Genome Browser Attributes");
        this.setPackage((Package)this.genomeBrowserPackage);
        this.addAttribute(IDENTIFIER, new EntityType.AttributeRole[]{EntityType.AttributeRole.ROLE_ID}).setLabel("Identifier").setAuto(false).setNillable(false);
        this.addAttribute(DEFAULT, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setLabel("Default configuration");
        this.addAttribute(ORDER, new EntityType.AttributeRole[0]).setDataType(AttributeType.INT).setVisibleExpression("$('default').eq(true).value()").setUnique(true).setLabel("Order").setDescription("The order in which the attributes of an entity are matched to these configurations, first match wins");
        this.addAttribute(POS, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setNillable(false).setLabel("Position attribute name");
        this.addAttribute(CHROM, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setNillable(false).setLabel("Chromosome attribute name");
        this.addAttribute(REF, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setLabel("Reference allele attribute name");
        this.addAttribute(ALT, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setLabel("Alternative allele attribute name");
        this.addAttribute(STOP, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setLabel("Stop position attribute name");
    }
}

