/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser.service;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONObject;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.security.EntityTypeIdentity;
import org.molgenis.data.security.EntityTypePermission;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.genomebrowser.GenomeBrowserTrack;
import org.molgenis.genomebrowser.meta.GenomeBrowserAttributes;
import org.molgenis.genomebrowser.meta.GenomeBrowserSettings;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.UserPermissionEvaluator;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.stereotype.Component;

@Component
public class GenomeBrowserService {
    private final DataService dataService;
    private final UserPermissionEvaluator userPermissionEvaluator;

    public GenomeBrowserService(DataService dataService, UserPermissionEvaluator userPermissionEvaluator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.userPermissionEvaluator = Objects.requireNonNull(userPermissionEvaluator);
    }

    public Map<String, GenomeBrowserTrack> getGenomeBrowserTracks(EntityType entityType) {
        return this.hasPermission() ? this.getGenomeBrowserTracks(entityType, this.getDefaultGenomeBrowserAttributes().collect(Collectors.toList())) : Collections.emptyMap();
    }

    public List<JSONObject> getTracksJson(Map<String, GenomeBrowserTrack> entityTracks) {
        List<Object> results = new ArrayList<JSONObject>();
        if (this.hasPermission()) {
            HashMap<String, GenomeBrowserTrack> allTracks = new HashMap<String, GenomeBrowserTrack>(entityTracks);
            for (GenomeBrowserTrack track : entityTracks.values()) {
                allTracks.putAll(this.getReferenceTracks(track));
            }
            results = allTracks.values().stream().map(GenomeBrowserTrack::toTrackJson).collect(Collectors.toList());
        }
        return results;
    }

    private Map<String, GenomeBrowserTrack> getGenomeBrowserTracks(EntityType entityType, List<GenomeBrowserAttributes> defaultGenomeBrowserAttributes) {
        HashMap<String, GenomeBrowserTrack> settings = new HashMap<String, GenomeBrowserTrack>();
        this.dataService.findAll("sys_genomebrowser_GenomeBrowserSettings", new QueryImpl().eq("entity", entityType.getIdValue()), GenomeBrowserSettings.class).forEach(referenceSettings -> settings.put(referenceSettings.getIdentifier(), GenomeBrowserTrack.create(referenceSettings)));
        if (settings.isEmpty()) {
            Collections.sort(defaultGenomeBrowserAttributes);
            for (GenomeBrowserAttributes genomeBrowserAttributes : defaultGenomeBrowserAttributes) {
                ArrayList attributeNames;
                if (!this.areAllAttributeAvailable(genomeBrowserAttributes, attributeNames = Lists.newArrayList((Iterable)entityType.getAttributeNames()))) continue;
                GenomeBrowserTrack genomeBrowserTrack = this.getDefaultGenomeBrowserSettingsEntity(entityType, genomeBrowserAttributes);
                settings.put(genomeBrowserTrack.getId(), genomeBrowserTrack);
                break;
            }
        }
        return settings;
    }

    Map<String, GenomeBrowserTrack> getReferenceTracks(GenomeBrowserTrack settings) {
        HashMap<String, GenomeBrowserTrack> result = new HashMap<String, GenomeBrowserTrack>();
        if (this.hasPermission() && settings.getMolgenisReferenceMode() != GenomeBrowserSettings.MolgenisReferenceMode.NONE) {
            if (settings.getMolgenisReferenceMode() == GenomeBrowserSettings.MolgenisReferenceMode.CONFIGURED) {
                settings.getMolgenisReferenceTracks().forEach(referenceTrack -> result.put(referenceTrack.getId(), (GenomeBrowserTrack)referenceTrack));
            } else {
                List<GenomeBrowserAttributes> defaultGenomeBrowserAttributes = this.getDefaultGenomeBrowserAttributes().collect(Collectors.toList());
                for (EntityType entityType : this.dataService.getMeta().getEntityTypes().collect(Collectors.toList())) {
                    if (entityType.isAbstract() || entityType.equals(settings.getEntity())) continue;
                    this.getGenomeBrowserTracks(entityType, defaultGenomeBrowserAttributes).values().forEach(referenceSettings -> result.put(referenceSettings.getId(), (GenomeBrowserTrack)referenceSettings));
                }
            }
        }
        return result;
    }

    private boolean hasPermission() {
        return this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity("sys_genomebrowser_GenomeBrowserSettings"), (Permission)EntityTypePermission.READ_DATA) && this.userPermissionEvaluator.hasPermission((ObjectIdentity)new EntityTypeIdentity("sys_genomebrowser_GenomeBrowserAttributes"), (Permission)EntityTypePermission.READ_DATA);
    }

    private Stream<GenomeBrowserAttributes> getDefaultGenomeBrowserAttributes() {
        return this.dataService.findAll("sys_genomebrowser_GenomeBrowserAttributes", new QueryImpl().eq("default", (Object)true), GenomeBrowserAttributes.class);
    }

    private boolean isAttributeAvailable(String attributeName, Iterable<String> attributeNames) {
        return attributeName == null || Iterables.contains(attributeNames, (Object)attributeName);
    }

    private boolean areAllAttributeAvailable(GenomeBrowserAttributes genomeBrowserAttributes, Iterable<String> attributeNames) {
        return this.isAttributeAvailable(genomeBrowserAttributes.getChrom(), attributeNames) && this.isAttributeAvailable(genomeBrowserAttributes.getPos(), attributeNames) && this.isAttributeAvailable(genomeBrowserAttributes.getAlt(), attributeNames) && this.isAttributeAvailable(genomeBrowserAttributes.getRef(), attributeNames) && this.isAttributeAvailable(genomeBrowserAttributes.getStop(), attributeNames);
    }

    private GenomeBrowserTrack getDefaultGenomeBrowserSettingsEntity(EntityType entityType, GenomeBrowserAttributes attrs) {
        return GenomeBrowserTrack.create(entityType.getIdValue().toString(), entityType.getLabel(), entityType.getLabelAttribute().getName(), entityType, GenomeBrowserSettings.TrackType.VARIANT, Collections.emptyList(), GenomeBrowserSettings.MolgenisReferenceMode.ALL, attrs, null, null, null, null);
    }
}

