/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser;

import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.genomebrowser.AutoValue_GenomeBrowserTrack;
import org.molgenis.genomebrowser.meta.GenomeBrowserAttributes;
import org.molgenis.genomebrowser.meta.GenomeBrowserSettings;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class GenomeBrowserTrack {
    public static GenomeBrowserTrack create(String id, String label, String labelAttr, EntityType entity, GenomeBrowserSettings.TrackType trackType, Iterable<GenomeBrowserTrack> molgenisReferenceTracks, GenomeBrowserSettings.MolgenisReferenceMode molgenisReferenceMode, GenomeBrowserAttributes genomeBrowserAttrs, String actions, String attrs, String scoreAttr, String exonKey) {
        return new AutoValue_GenomeBrowserTrack(id, label, labelAttr, entity, trackType, molgenisReferenceTracks, molgenisReferenceMode, genomeBrowserAttrs, actions, attrs, scoreAttr, exonKey);
    }

    public static GenomeBrowserTrack create(GenomeBrowserSettings settings) {
        return new AutoValue_GenomeBrowserTrack(settings.getIdentifier(), settings.getLabel(), settings.getLabelAttr().getName(), settings.getEntity(), settings.getTrackType(), settings.getMolgenisReferenceTracks().collect(Collectors.toList()), settings.getMolgenisReferenceMode(), settings.getGenomeBrowserAttrs(), settings.getActions(), settings.getAttrs(), settings.getScoreAttr(), settings.getExonKey());
    }

    public abstract String getId();

    public abstract String getLabel();

    public abstract String getLabelAttr();

    public abstract EntityType getEntity();

    public abstract GenomeBrowserSettings.TrackType getTrackType();

    @Nullable
    public abstract Iterable<GenomeBrowserTrack> getMolgenisReferenceTracks();

    public abstract GenomeBrowserSettings.MolgenisReferenceMode getMolgenisReferenceMode();

    public abstract GenomeBrowserAttributes getGenomeBrowserAttrs();

    @Nullable
    public abstract String getActions();

    @Nullable
    public abstract String getAttrs();

    @Nullable
    public abstract String getScoreAttr();

    @Nullable
    public abstract String getExonKey();

    public JSONObject toTrackJson() {
        JSONObject json = new JSONObject();
        json.put("name", (Object)this.getLabel());
        json.put("entity", (Object)this.getEntity().getId());
        json.put("tier_type", (Object)"molgenis");
        json.put("uri", (Object)UriComponentsBuilder.fromPath((String)"/api/v2").pathSegment(new String[]{this.getEntity().getId()}).toUriString());
        json.put("genome_attrs", (Object)this.getGenomeBrowserAttrsJSON(this.getGenomeBrowserAttrs()));
        if (this.getLabelAttr() != null) {
            json.put("label_attr", (Object)this.getLabelAttr());
        }
        if (this.getAttrs() != null) {
            json.put("attrs", (Object)this.getAttrsJSON(this.getAttrs()));
        }
        if (this.getActions() != null) {
            json.put("actions", (Object)this.getActions());
        }
        if (this.getTrackType() != null) {
            json.put("track_type", (Object)this.getTrackType());
        }
        if (this.getScoreAttr() != null) {
            json.put("score_attr", (Object)this.getScoreAttr());
        }
        if (this.getExonKey() != null) {
            json.put("exon_key", (Object)this.getExonKey());
        }
        return json;
    }

    private JSONObject getGenomeBrowserAttrsJSON(GenomeBrowserAttributes genomeBrowserAttrs) {
        JSONObject genomeAttrsJSON = new JSONObject();
        genomeAttrsJSON.put("chr", (Object)genomeBrowserAttrs.getChrom());
        genomeAttrsJSON.put("pos", (Object)genomeBrowserAttrs.getPos());
        if (genomeBrowserAttrs.getRef() != null) {
            genomeAttrsJSON.put("ref", (Object)genomeBrowserAttrs.getRef());
        }
        if (genomeBrowserAttrs.getAlt() != null) {
            genomeAttrsJSON.put("alt", (Object)genomeBrowserAttrs.getAlt());
        }
        if (genomeBrowserAttrs.getStop() != null) {
            genomeAttrsJSON.put("stop", (Object)genomeBrowserAttrs.getStop());
        }
        return genomeAttrsJSON;
    }

    private JSONArray getAttrsJSON(String attrsString) {
        String[] attrs;
        JSONArray attrsArray = new JSONArray();
        for (String attr : attrs = attrsString.split(",")) {
            attrsArray.put((Object)attr);
        }
        return attrsArray;
    }
}

