/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser.meta;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.StaticEntity;
import org.molgenis.genomebrowser.GenomeBrowserTrack;
import org.molgenis.genomebrowser.meta.GenomeBrowserAttributes;

public class GenomeBrowserSettings
extends StaticEntity {
    public GenomeBrowserSettings(Entity entity) {
        super(entity);
    }

    public GenomeBrowserSettings(EntityType entityType) {
        super(entityType);
    }

    public GenomeBrowserSettings(String identifier, EntityType entityType) {
        super((Object)identifier, entityType);
    }

    public String getIdentifier() {
        return this.getString("id");
    }

    public void setIdentifier(String identifier) {
        this.set("id", identifier);
    }

    public String getLabel() {
        return this.getString("label");
    }

    public void setLabel(String label) {
        this.set("label", label);
    }

    public Attribute getLabelAttr() {
        return (Attribute)this.getEntity("labelAttr", Attribute.class);
    }

    public void setLabelAttr(Attribute labelAttr) {
        this.set("labelAttr", labelAttr);
    }

    public EntityType getEntity() {
        return (EntityType)this.getEntity("entity", EntityType.class);
    }

    public void setEntity(EntityType entity) {
        this.set("entity", entity);
    }

    public TrackType getTrackType() {
        String string = this.getString("track_type");
        return string != null ? TrackType.valueOf(string.toUpperCase()) : null;
    }

    public void setTrackType(TrackType trackType) {
        this.set("track_type", trackType.toString().toUpperCase());
    }

    public Stream<GenomeBrowserTrack> getMolgenisReferenceTracks() {
        return StreamSupport.stream(this.getEntities("molgenis_reference_tracks", GenomeBrowserSettings.class).spliterator(), false).map(settings -> GenomeBrowserTrack.create(settings));
    }

    public void setMolgenisReferenceTracks(GenomeBrowserSettings molgenisReferenceTracks) {
        this.set("molgenis_reference_tracks", (Object)molgenisReferenceTracks);
    }

    public MolgenisReferenceMode getMolgenisReferenceMode() {
        String string = this.getString("molgenis_reference_tracks_mode");
        return string != null ? MolgenisReferenceMode.valueOf(this.getString("molgenis_reference_tracks_mode").toUpperCase()) : null;
    }

    public void setMolgenisReferenceMode(MolgenisReferenceMode mode) {
        this.set("molgenis_reference_tracks_mode", mode.toString().toUpperCase());
    }

    public GenomeBrowserAttributes getGenomeBrowserAttrs() {
        return (GenomeBrowserAttributes)this.getEntity("genome_browser_attrs", GenomeBrowserAttributes.class);
    }

    public void setGenomeBrowserAttrs(GenomeBrowserAttributes genomeBrowserAttrs) {
        this.set("genome_browser_attrs", genomeBrowserAttrs);
    }

    @Nullable
    public String getActions() {
        return this.getString("actions");
    }

    public void setActions(String actions) {
        this.set("actions", actions);
    }

    @Nullable
    public String getAttrs() {
        return this.getString("attrs");
    }

    public void setAttrs(String attrs) {
        this.set("attrs", attrs);
    }

    @Nullable
    public String getScoreAttr() {
        return this.getString("scoreAttr");
    }

    public void setScoreAttr(String scoreAttr) {
        this.set("scoreAttr", scoreAttr);
    }

    @Nullable
    public String getExonKey() {
        return this.getString("exon_key");
    }

    public void setExonKey(String exonKe) {
        this.set("exon_key", exonKe);
    }

    public static enum MolgenisReferenceMode {
        ALL,
        NONE,
        CONFIGURED;

    }

    public static enum TrackType {
        VARIANT,
        NUMERIC,
        EXON;

    }
}

