/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.genomebrowser;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.genomebrowser.AutoValue_GenomeBrowserTrack;
import org.molgenis.genomebrowser.meta.GenomeBrowserAttributes;
import org.molgenis.genomebrowser.meta.GenomeBrowserSettings;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class GenomeBrowserTrack {
    public static GenomeBrowserTrack create(String id, String label, String labelAttr, EntityType entity, GenomeBrowserSettings.TrackType trackType, Iterable<GenomeBrowserTrack> molgenisReferenceTracks, GenomeBrowserSettings.MolgenisReferenceMode molgenisReferenceMode, GenomeBrowserAttributes genomeBrowserAttrs, String actions, String attrs, String scoreAttr, String exonKey, String featureInfoPlugin) {
        return new AutoValue_GenomeBrowserTrack(id, label, labelAttr, entity, trackType, molgenisReferenceTracks, molgenisReferenceMode, genomeBrowserAttrs, actions, attrs, scoreAttr, exonKey, featureInfoPlugin);
    }

    public static GenomeBrowserTrack create(GenomeBrowserSettings settings) {
        return new AutoValue_GenomeBrowserTrack(settings.getIdentifier(), settings.getLabel(), settings.getLabelAttr().getName(), settings.getEntity(), settings.getTrackType(), settings.getMolgenisReferenceTracks().collect(Collectors.toList()), settings.getMolgenisReferenceMode(), settings.getGenomeBrowserAttrs(), settings.getActions(), settings.getAttrs(), settings.getScoreAttr(), settings.getExonKey(), settings.getFeatureInfoPlugin());
    }

    public abstract String getId();

    public abstract String getLabel();

    public abstract String getLabelAttr();

    public abstract EntityType getEntity();

    public abstract GenomeBrowserSettings.TrackType getTrackType();

    @Nullable
    public abstract Iterable<GenomeBrowserTrack> getMolgenisReferenceTracks();

    public abstract GenomeBrowserSettings.MolgenisReferenceMode getMolgenisReferenceMode();

    public abstract GenomeBrowserAttributes getGenomeBrowserAttrs();

    @Nullable
    public abstract String getActions();

    @Nullable
    public abstract String getAttrs();

    @Nullable
    public abstract String getScoreAttr();

    @Nullable
    public abstract String getExonKey();

    @Nullable
    public abstract String getFeatureInfoPlugin();

    public String toTrackString() {
        StringBuilder config = new StringBuilder("{");
        config.append(this.getConfigStringValue("name", this.getLabel()));
        config.append(",").append(this.getConfigStringValue("entity", this.getEntity().getId()));
        config.append(",").append(this.getConfigStringValue("tier_type", "molgenis"));
        config.append(",").append(this.getConfigStringValue("uri", UriComponentsBuilder.fromPath((String)"/api/v2").pathSegment(new String[]{this.getEntity().getId()}).toUriString()));
        config.append(",").append(String.format("\"%s\":%s", "genome_attrs", this.getGenomeBrowserAttrsJSON(this.getGenomeBrowserAttrs()).toString()));
        if (this.getLabelAttr() != null) {
            config.append(",").append(this.getConfigStringValue("label_attr", this.getLabelAttr()));
        }
        if (this.getAttrs() != null) {
            config.append(",").append(this.getConfigObjectValue("attrs", this.getAttrsJSON(this.getAttrs()).toString()));
        }
        if (this.getActions() != null) {
            config.append(",").append(this.getConfigObjectValue("actions", JSONObject.quote((String)this.getActions())));
        }
        if (this.getTrackType() != null) {
            config.append(",").append(this.getConfigStringValue("track_type", this.getTrackType().name()));
        }
        if (this.getScoreAttr() != null) {
            config.append(",").append(this.getConfigStringValue("score_attr", this.getScoreAttr()));
        }
        if (this.getExonKey() != null) {
            config.append(",").append(this.getConfigStringValue("exon_key", this.getExonKey()));
        }
        if (!Strings.isNullOrEmpty((String)this.getFeatureInfoPlugin())) {
            config.append(",").append(this.getConfigObjectValue("featureInfoPlugin", String.format("function(f, info) {%s}", this.getFeatureInfoPlugin())));
        }
        config.append("}");
        return config.toString();
    }

    private String getConfigObjectValue(String key, String value) {
        return String.format("\"%s\":%s", key, value);
    }

    private String getConfigStringValue(String key, String value) {
        return String.format("\"%s\":\"%s\"", key, value);
    }

    private JSONObject getGenomeBrowserAttrsJSON(GenomeBrowserAttributes genomeBrowserAttrs) {
        JSONObject genomeAttrsJSON = new JSONObject();
        genomeAttrsJSON.put("chr", (Object)genomeBrowserAttrs.getChrom());
        genomeAttrsJSON.put("pos", (Object)genomeBrowserAttrs.getPos());
        if (genomeBrowserAttrs.getRef() != null) {
            genomeAttrsJSON.put("ref", (Object)genomeBrowserAttrs.getRef());
        }
        if (genomeBrowserAttrs.getAlt() != null) {
            genomeAttrsJSON.put("alt", (Object)genomeBrowserAttrs.getAlt());
        }
        if (genomeBrowserAttrs.getStop() != null) {
            genomeAttrsJSON.put("stop", (Object)genomeBrowserAttrs.getStop());
        }
        return genomeAttrsJSON;
    }

    private JSONArray getAttrsJSON(String attrsString) {
        String[] attrs;
        JSONArray attrsArray = new JSONArray();
        for (String attr : attrs = attrsString.split(",")) {
            attrsArray.put((Object)attr);
        }
        return attrsArray;
    }
}

