/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.util.Locale;
import java.util.function.Supplier;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.i18n.Labeled;
import org.molgenis.i18n.LanguageService;
import org.molgenis.i18n.LocalizationMessageSource;
import org.molgenis.i18n.MessageResolution;
import org.molgenis.i18n.format.MessageFormatFactory;
import org.molgenis.test.AbstractMockitoTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalizationMessageSourceTest
extends AbstractMockitoTest {
    @Mock
    private MessageResolution messageRepository;
    @Mock
    private Labeled labeled;
    @Mock
    private Supplier<Locale> fallbackLocaleSupplier;
    private LocalizationMessageSource messageSource;
    private MessageFormatFactory messageFormatFactory = new MessageFormatFactory();

    @BeforeMethod
    public void setUp() {
        this.messageSource = new LocalizationMessageSource(this.messageFormatFactory, this.messageRepository, this.fallbackLocaleSupplier);
    }

    @Test
    public void testGetDefaultMessage() {
        Assert.assertEquals((String)this.messageSource.getDefaultMessage("CODE"), (String)"#CODE#");
    }

    @Test
    public void testResolveCodeWithoutArgumentsMessageFoundForCode() {
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_DE", Locale.GERMAN)).thenReturn((Object)"Deutsche Nachricht");
        Assert.assertEquals((String)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_DE", Locale.GERMAN), (String)"Deutsche Nachricht");
    }

    @Test
    public void testResolveCodeWithoutArgumentsMessageFoundForAppDefaultLanguage() {
        ((Supplier)Mockito.doReturn((Object)new Locale("nl")).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn(null).when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_NL", Locale.GERMAN);
        ((MessageResolution)Mockito.doReturn((Object)"Nederlands bericht").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_NL", new Locale("nl"));
        Assert.assertEquals((String)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_NL", Locale.GERMAN), (String)"Nederlands bericht");
    }

    @Test
    public void testResolveCodeWithoutArgumentsMessageFoundForDefaultLanguage() {
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH)).thenReturn((Object)"English message");
        Assert.assertEquals((String)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH), (String)"English message");
    }

    @Test
    public void testResolveCodeWithoutArgumentsMessageNotFound() {
        Assert.assertNull((Object)this.messageSource.resolveCodeWithoutArguments("MISSING", new Locale("en")));
    }

    @Test
    public void testResolveCode() {
        ((Labeled)Mockito.doReturn((Object)"The Label").when((Object)this.labeled)).getLabel("en");
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH)).thenReturn((Object)"label: ''{0, label}''");
        Assert.assertEquals((String)this.messageSource.resolveCode("TEST_MESSAGE_EN", Locale.ENGLISH).format(new Object[]{this.labeled}), (String)"label: 'The Label'");
    }

    @Test
    public void testResolveCodeFallbackIsIndependentOfArgumentFallback() {
        ((Supplier)Mockito.doReturn((Object)new Locale("nl")).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn(null).when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_EN", new Locale("ko"));
        ((Labeled)Mockito.doReturn((Object)"The Label (ko)").when((Object)this.labeled)).getLabel("ko");
        ((MessageResolution)Mockito.doReturn((Object)"Het label: ''{0, label}''").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_EN", new Locale("nl"));
        Assert.assertEquals((String)this.messageSource.resolveCode("TEST_MESSAGE_EN", Locale.KOREAN).format(new Object[]{this.labeled}), (String)"Het label: 'The Label (ko)'");
    }

    @Test
    public void testResolveCodeWithoutArgumentsSupplierFails() {
        ((Supplier)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn((Object)"test").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST", LanguageService.DEFAULT_LOCALE);
        Assert.assertEquals((String)this.messageSource.resolveCodeWithoutArguments("TEST", null), (String)"test");
    }
}

