/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.molgenis.i18n.MessageSourceHolder;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceResourceBundle;

public class LanguageService {
    public static final String LANGUAGE_CODE_EN = "en";
    private static final String LANGUAGE_CODE_DE = "de";
    public static final String LANGUAGE_CODE_NL = "nl";
    private static final String LANGUAGE_CODE_ES = "es";
    private static final String LANGUAGE_CODE_IT = "it";
    private static final String LANGUAGE_CODE_PT = "pt";
    private static final String LANGUAGE_CODE_FR = "fr";
    private static final String LANGUAGE_CODE_XX = "xx";
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    public static final String DEFAULT_LANGUAGE_CODE = "en";
    public static final String DEFAULT_LANGUAGE_NAME = "English";

    private LanguageService() {
    }

    public static Stream<String> getLanguageCodes() {
        return Stream.of("en", LANGUAGE_CODE_NL, LANGUAGE_CODE_DE, LANGUAGE_CODE_ES, LANGUAGE_CODE_IT, LANGUAGE_CODE_PT, LANGUAGE_CODE_FR, LANGUAGE_CODE_XX);
    }

    public static boolean hasLanguageCode(String code) {
        return LanguageService.getLanguageCodes().anyMatch(languageCode -> languageCode.equals(code));
    }

    @Deprecated
    public static MessageSourceResourceBundle getBundle() {
        return new MessageSourceResourceBundle(MessageSourceHolder.getMessageSource(), LocaleContextHolder.getLocale());
    }

    @Deprecated
    public static String getCurrentUserLanguageCode() {
        return LocaleContextHolder.getLocale().getLanguage();
    }

    @Deprecated
    public static Optional<String> formatMessage(String code, Object[] arguments) {
        try {
            return Optional.of(MessageSourceHolder.getMessageSource().getMessage(code, arguments, LocaleContextHolder.getLocale()));
        }
        catch (NoSuchMessageException ex) {
            return Optional.empty();
        }
    }
}

