/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import com.google.common.collect.ImmutableSetMultimap;
import java.util.Locale;
import org.molgenis.i18n.properties.AllPropertiesMessageSource;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AllPropertiesMessageSourceTest {
    private AllPropertiesMessageSource propertiesMessageSource;
    private Locale DUTCH = new Locale("nl");

    @BeforeMethod
    public void setUp() throws Exception {
        this.propertiesMessageSource = new AllPropertiesMessageSource();
        this.propertiesMessageSource.addMolgenisNamespaces(new String[]{"test"});
    }

    @AfterMethod
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetAllMessageIds() throws Exception {
        Assert.assertEquals((Object)this.propertiesMessageSource.getAllMessageIds(), (Object)ImmutableSetMultimap.of((Object)"test", (Object)"EN_ONLY", (Object)"test", (Object)"EN_PLUS_NL", (Object)"test", (Object)"BIOBANK_UTF8", (Object)"test", (Object)"NL_ONLY"));
    }

    @Test
    public void testGetMessageSpecifiedInBundle() throws Exception {
        Assert.assertEquals((String)this.propertiesMessageSource.resolveCodeWithoutArguments("NL_ONLY", this.DUTCH), (String)"alleen Nederlands");
    }

    @Test
    public void testGetMessageSpecifiedInOtherBundle() throws Exception {
        Assert.assertNull((Object)this.propertiesMessageSource.resolveCodeWithoutArguments("EN_ONLY", new Locale("nl")));
    }

    @Test
    public void testGetMessageNotSpecified() throws Exception {
        Assert.assertNull((Object)this.propertiesMessageSource.resolveCodeWithoutArguments("MISSING", new Locale("nl")));
    }

    @Test
    public void testGetMessageSpecifiedInBoth() throws Exception {
        Assert.assertEquals((String)this.propertiesMessageSource.resolveCodeWithoutArguments("EN_PLUS_NL", Locale.ENGLISH), (String)"English plus Dutch");
        Assert.assertEquals((String)this.propertiesMessageSource.resolveCodeWithoutArguments("EN_PLUS_NL", new Locale("nl")), (String)"Engels plus Nederlands");
    }

    @Test
    public void testGetMessageUTF8() {
        Assert.assertEquals((String)this.propertiesMessageSource.resolveCodeWithoutArguments("BIOBANK_UTF8", Locale.ENGLISH), (String)"Bi\u00f8b\u00e5nk\ud83d\udc00");
    }
}

