/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n.properties;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.molgenis.i18n.LanguageService;
import org.springframework.context.support.ResourceBundleMessageSource;

public class AllPropertiesMessageSource
extends ResourceBundleMessageSource {
    public AllPropertiesMessageSource() {
        this.setAlwaysUseMessageFormat(false);
        this.setFallbackToSystemLocale(false);
        this.setUseCodeAsDefaultMessage(false);
        this.setDefaultEncoding("UTF-8");
    }

    public void addMolgenisNamespaces(String ... namespaces) {
        this.addBasenames((String[])Arrays.stream(namespaces).map(namespace -> "l10n." + namespace.trim().toLowerCase()).toArray(String[]::new));
    }

    public SetMultimap<String, String> getAllMessageIds() {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        this.getBasenameSet().forEach(basename -> result.putAll((Object)basename.substring(5), this.getMessageIds((String)basename)));
        return result.build();
    }

    private Set<String> getMessageIds(String basename) {
        TreeSet result = Sets.newTreeSet();
        for (String languageCode : LanguageService.getLanguageCodes().collect(Collectors.toList())) {
            Locale locale = new Locale(languageCode);
            ResourceBundle resourceBundle = this.getResourceBundle(basename, locale);
            if (resourceBundle == null) continue;
            Enumeration<String> keys = resourceBundle.getKeys();
            Iterators.forEnumeration(keys).forEachRemaining(result::add);
        }
        return result;
    }

    public String resolveCodeWithoutArguments(String code, Locale locale) {
        return super.resolveCodeWithoutArguments(code, locale);
    }
}

