/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.molgenis.i18n.LanguageService;
import org.molgenis.i18n.MessageResolution;
import org.molgenis.i18n.format.MessageFormatFactory;
import org.springframework.context.support.AbstractMessageSource;

public class LocalizationMessageSource
extends AbstractMessageSource {
    private final MessageFormatFactory messageFormatFactory;
    private final MessageResolution messageRepository;
    private final Supplier<Locale> fallbackLocaleSupplier;

    public LocalizationMessageSource(MessageFormatFactory messageFormatFactory, MessageResolution messageRepository, Supplier<Locale> fallbackLocaleSupplier) {
        this.messageFormatFactory = Objects.requireNonNull(messageFormatFactory);
        this.messageRepository = messageRepository;
        this.fallbackLocaleSupplier = fallbackLocaleSupplier;
        this.setAlwaysUseMessageFormat(false);
        this.setUseCodeAsDefaultMessage(false);
    }

    public String getDefaultMessage(String code) {
        return "#" + code + "#";
    }

    public MessageFormat resolveCode(String code, Locale locale) {
        String resolved = this.resolveCodeWithoutArguments(code, locale);
        if (resolved == null) {
            return null;
        }
        return this.createMessageFormat(resolved, locale);
    }

    protected MessageFormat createMessageFormat(String msg, Locale locale) {
        return this.messageFormatFactory.createMessageFormat(msg, locale);
    }

    protected String resolveCodeWithoutArguments(String code, @Nullable Locale locale) {
        Stream<Locale> candidates = Stream.of(locale, this.tryGetFallbackLocale(), LanguageService.DEFAULT_LOCALE);
        return candidates.filter(Objects::nonNull).map(candidate -> this.messageRepository.resolveCodeWithoutArguments(code, (Locale)candidate)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Locale tryGetFallbackLocale() {
        Locale fallbackLocale = null;
        try {
            fallbackLocale = this.fallbackLocaleSupplier.get();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return fallbackLocale;
    }
}

