/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.text.MessageFormat;
import java.util.Objects;
import org.molgenis.i18n.ErrorCoded;
import org.molgenis.i18n.MessageSourceHolder;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class CodedRuntimeException
extends RuntimeException
implements ErrorCoded {
    private final String errorCode;

    protected CodedRuntimeException(String errorCode) {
        this.errorCode = Objects.requireNonNull(errorCode);
    }

    protected CodedRuntimeException(String errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getLocalizedMessage() {
        try {
            return MessageSourceHolder.getMessageSource().getMessage(this.getErrorCode(), this.getLocalizedMessageArguments(), super.getLocalizedMessage(), LocaleContextHolder.getLocale());
        }
        catch (RuntimeException ex) {
            return MessageFormat.format("FAILED TO FORMAT LOCALIZED MESSAGE FOR ERROR CODE {0}.%nFallback message: {1}", this.errorCode, super.getLocalizedMessage());
        }
    }

    protected abstract Object[] getLocalizedMessageArguments();
}

