/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.util.Locale;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.i18n.ContextMessageSourceImpl;
import org.molgenis.i18n.MessageSourceHolder;
import org.molgenis.test.AbstractMockitoTest;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContextMessageSourceImplTest
extends AbstractMockitoTest {
    @Mock
    private MessageSource messageSource;
    private ContextMessageSourceImpl userMessageSourceImpl;

    @BeforeMethod
    public void setUpBeforeMethod() {
        this.userMessageSourceImpl = new ContextMessageSourceImpl();
    }

    @Test
    public void testGetMessageCode() {
        String message = "MyMessage";
        String code = "my_code";
        Locale locale = Locale.GERMAN;
        Mockito.when((Object)this.messageSource.getMessage(code, null, locale)).thenReturn((Object)message);
        LocaleContextHolder.setLocale((Locale)locale);
        MessageSourceHolder.setMessageSource((MessageSource)this.messageSource);
        AssertJUnit.assertEquals((String)this.userMessageSourceImpl.getMessage(code), (String)message);
    }

    @Test
    public void testGetMessageCodeArgs() {
        String message = "MyMessage";
        String code = "my_code";
        Object[] args = new Object[]{"arg0", "arg1"};
        Locale locale = Locale.GERMAN;
        Mockito.when((Object)this.messageSource.getMessage(code, args, locale)).thenReturn((Object)message);
        LocaleContextHolder.setLocale((Locale)locale);
        MessageSourceHolder.setMessageSource((MessageSource)this.messageSource);
        AssertJUnit.assertEquals((String)this.userMessageSourceImpl.getMessage(code, args), (String)message);
    }
}

