/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.i18n.ContextMessageSourceImpl;
import org.molgenis.test.AbstractMockitoTest;
import org.molgenis.util.i18n.MessageSourceHolder;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

class ContextMessageSourceImplTest
extends AbstractMockitoTest {
    @Mock
    private MessageSource messageSource;
    private ContextMessageSourceImpl userMessageSourceImpl;

    ContextMessageSourceImplTest() {
    }

    @BeforeEach
    void setUpBeforeMethod() {
        this.userMessageSourceImpl = new ContextMessageSourceImpl();
    }

    @Test
    void testGetMessageCode() {
        String message = "MyMessage";
        String code = "my_code";
        Locale locale = Locale.GERMAN;
        Mockito.when((Object)this.messageSource.getMessage(code, null, locale)).thenReturn((Object)message);
        LocaleContextHolder.setLocale((Locale)locale);
        MessageSourceHolder.setMessageSource((MessageSource)this.messageSource);
        Assertions.assertEquals((Object)message, (Object)this.userMessageSourceImpl.getMessage(code));
    }

    @Test
    void testGetMessageCodeArgs() {
        String message = "MyMessage";
        String code = "my_code";
        Object[] args = new Object[]{"arg0", "arg1"};
        Locale locale = Locale.GERMAN;
        Mockito.when((Object)this.messageSource.getMessage(code, args, locale)).thenReturn((Object)message);
        LocaleContextHolder.setLocale((Locale)locale);
        MessageSourceHolder.setMessageSource((MessageSource)this.messageSource);
        Assertions.assertEquals((Object)message, (Object)this.userMessageSourceImpl.getMessage(code, args));
    }
}

