/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.i18n;

import java.util.Locale;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.i18n.LocalizationMessageSource;
import org.molgenis.i18n.MessageResolution;
import org.molgenis.test.AbstractMockitoTest;
import org.molgenis.util.i18n.Labeled;
import org.molgenis.util.i18n.LanguageService;
import org.molgenis.util.i18n.format.MessageFormatFactory;

class LocalizationMessageSourceTest
extends AbstractMockitoTest {
    @Mock
    private MessageResolution messageRepository;
    @Mock
    private Labeled labeled;
    @Mock
    private Supplier<Locale> fallbackLocaleSupplier;
    private LocalizationMessageSource messageSource;
    private MessageFormatFactory messageFormatFactory = new MessageFormatFactory();

    LocalizationMessageSourceTest() {
    }

    @BeforeEach
    void setUp() {
        this.messageSource = new LocalizationMessageSource(this.messageFormatFactory, this.messageRepository, this.fallbackLocaleSupplier);
    }

    @Test
    void testGetDefaultMessage() {
        Assertions.assertEquals((Object)"#CODE#", (Object)this.messageSource.getDefaultMessage("CODE"));
    }

    @Test
    void testResolveCodeWithoutArgumentsMessageFoundForCode() {
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_DE", Locale.GERMAN)).thenReturn((Object)"Deutsche Nachricht");
        Assertions.assertEquals((Object)"Deutsche Nachricht", (Object)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_DE", Locale.GERMAN));
    }

    @Test
    void testResolveCodeWithoutArgumentsMessageFoundForAppDefaultLanguage() {
        ((Supplier)Mockito.doReturn((Object)new Locale("nl")).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn(null).when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_NL", Locale.GERMAN);
        ((MessageResolution)Mockito.doReturn((Object)"Nederlands bericht").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_NL", new Locale("nl"));
        Assertions.assertEquals((Object)"Nederlands bericht", (Object)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_NL", Locale.GERMAN));
    }

    @Test
    void testResolveCodeWithoutArgumentsMessageFoundForDefaultLanguage() {
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH)).thenReturn((Object)"English message");
        Assertions.assertEquals((Object)"English message", (Object)this.messageSource.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH));
    }

    @Test
    void testResolveCodeWithoutArgumentsMessageNotFound() {
        Assertions.assertNull((Object)this.messageSource.resolveCodeWithoutArguments("MISSING", new Locale("en")));
    }

    @Test
    void testResolveCode() {
        ((Labeled)Mockito.doReturn((Object)"The Label").when((Object)this.labeled)).getLabel("en");
        Mockito.when((Object)this.messageRepository.resolveCodeWithoutArguments("TEST_MESSAGE_EN", Locale.ENGLISH)).thenReturn((Object)"label: ''{0, label}''");
        Assertions.assertEquals((Object)"label: 'The Label'", (Object)this.messageSource.resolveCode("TEST_MESSAGE_EN", Locale.ENGLISH).format(new Object[]{this.labeled}));
    }

    @Test
    void testResolveCodeFallbackIsIndependentOfArgumentFallback() {
        ((Supplier)Mockito.doReturn((Object)new Locale("nl")).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn(null).when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_EN", new Locale("ko"));
        ((Labeled)Mockito.doReturn((Object)"The Label (ko)").when((Object)this.labeled)).getLabel("ko");
        ((MessageResolution)Mockito.doReturn((Object)"Het label: ''{0, label}''").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST_MESSAGE_EN", new Locale("nl"));
        Assertions.assertEquals((Object)"Het label: 'The Label (ko)'", (Object)this.messageSource.resolveCode("TEST_MESSAGE_EN", Locale.KOREAN).format(new Object[]{this.labeled}));
    }

    @Test
    void testResolveCodeWithoutArgumentsSupplierFails() {
        ((Supplier)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when(this.fallbackLocaleSupplier)).get();
        ((MessageResolution)Mockito.doReturn((Object)"test").when((Object)this.messageRepository)).resolveCodeWithoutArguments("TEST", LanguageService.DEFAULT_LOCALE);
        Assertions.assertEquals((Object)"test", (Object)this.messageSource.resolveCodeWithoutArguments("TEST", null));
    }
}

