/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.controller;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.i18n.LanguageService;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.metadata.manager.model.EditorAttributeResponse;
import org.molgenis.metadata.manager.model.EditorEntityType;
import org.molgenis.metadata.manager.model.EditorEntityTypeResponse;
import org.molgenis.metadata.manager.model.EditorPackageIdentifier;
import org.molgenis.metadata.manager.service.MetadataManagerService;
import org.molgenis.security.user.UserAccountService;
import org.molgenis.ui.controller.VuePluginController;
import org.molgenis.ui.menu.MenuReaderService;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/metadata-manager"})
public class MetadataManagerController
extends VuePluginController {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataManagerController.class);
    public static final String METADATA_MANAGER = "metadata-manager";
    public static final String URI = "/plugin/metadata-manager";
    private MetadataManagerService metadataManagerService;

    public MetadataManagerController(MenuReaderService menuReaderService, LanguageService languageService, AppSettings appSettings, MetadataManagerService metadataManagerService, UserAccountService userAccountService) {
        super(URI, menuReaderService, languageService, appSettings, userAccountService);
        this.metadataManagerService = Objects.requireNonNull(metadataManagerService);
    }

    @GetMapping(value={"/**"})
    public String init(Model model) {
        super.init(model, METADATA_MANAGER);
        return "view-metadata-manager";
    }

    @ResponseBody
    @GetMapping(value={"/editorPackages"}, produces={"application/json"})
    public List<EditorPackageIdentifier> getEditorPackages() {
        return this.metadataManagerService.getEditorPackages();
    }

    @ResponseBody
    @GetMapping(value={"/entityType/{id:.*}"}, produces={"application/json"})
    public EditorEntityTypeResponse getEditorEntityType(@PathVariable(value="id") String id) {
        return this.metadataManagerService.getEditorEntityType(id);
    }

    @ResponseBody
    @GetMapping(value={"/create/entityType"}, produces={"application/json"})
    public EditorEntityTypeResponse createEditorEntityType() {
        return this.metadataManagerService.createEditorEntityType();
    }

    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/entityType"}, consumes={"application/json"})
    public void upsertEntityType(@RequestBody EditorEntityType editorEntityType) {
        this.metadataManagerService.upsertEntityType(editorEntityType);
    }

    @ResponseBody
    @GetMapping(value={"/create/attribute"}, produces={"application/json"})
    public EditorAttributeResponse createEditorAttribute() {
        return this.metadataManagerService.createEditorAttribute();
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={UnknownEntityException.class})
    public ErrorMessageResponse handleUnknownEntityException(UnknownEntityException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={RuntimeException.class})
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }
}

