/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeFactory;
import org.molgenis.data.support.AttributeUtils;
import org.molgenis.i18n.LanguageService;
import org.molgenis.metadata.manager.mapper.AttributeReferenceMapper;
import org.molgenis.metadata.manager.mapper.EntityTypeReferenceMapper;
import org.molgenis.metadata.manager.mapper.SortMapper;
import org.molgenis.metadata.manager.mapper.TagMapper;
import org.molgenis.metadata.manager.model.EditorAttribute;
import org.molgenis.metadata.manager.model.EditorAttributeIdentifier;
import org.molgenis.metadata.manager.model.EditorEntityType;
import org.molgenis.metadata.manager.model.EditorEntityTypeIdentifier;
import org.molgenis.metadata.manager.model.EditorSort;
import org.molgenis.metadata.manager.model.EditorTagIdentifier;
import org.springframework.stereotype.Component;

@Component
public class AttributeMapper {
    private final AttributeFactory attributeFactory;
    private final TagMapper tagMapper;
    private final EntityTypeReferenceMapper entityTypeReferenceMapper;
    private final AttributeReferenceMapper attributeReferenceMapper;
    private final SortMapper sortMapper;

    AttributeMapper(AttributeFactory attributeFactory, TagMapper tagMapper, EntityTypeReferenceMapper entityTypeReferenceMapper, AttributeReferenceMapper attributeReferenceMapper, SortMapper sortMapper) {
        this.attributeFactory = Objects.requireNonNull(attributeFactory);
        this.tagMapper = Objects.requireNonNull(tagMapper);
        this.entityTypeReferenceMapper = Objects.requireNonNull(entityTypeReferenceMapper);
        this.attributeReferenceMapper = Objects.requireNonNull(attributeReferenceMapper);
        this.sortMapper = Objects.requireNonNull(sortMapper);
    }

    public EditorAttribute createEditorAttribute() {
        Attribute attribute = this.attributeFactory.create();
        return this.toEditorAttribute(attribute);
    }

    Iterable<Attribute> toAttributes(List<EditorAttribute> editorAttributes, EditorEntityType editorEntityType) {
        Map attributeMap = IntStream.range(0, editorAttributes.size()).mapToObj(i -> this.toAttribute(i, (EditorAttribute)editorAttributes.get(i), editorEntityType)).collect(Collectors.toMap(Attribute::getIdentifier, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        return this.injectAttributeParents(attributeMap, editorAttributes);
    }

    private Iterable<Attribute> injectAttributeParents(Map<String, Attribute> attributeMap, List<EditorAttribute> editorAttributes) {
        editorAttributes.forEach(editorAttribute -> {
            EditorAttributeIdentifier editorAttributeParent = editorAttribute.getParent();
            if (editorAttributeParent != null) {
                String attributeId = editorAttribute.getId();
                String attributeParentId = editorAttributeParent.getId();
                Attribute attribute = (Attribute)attributeMap.get(attributeId);
                Attribute parentAttribute = (Attribute)attributeMap.get(attributeParentId);
                attribute.setParent(parentAttribute);
            }
        });
        return attributeMap.values();
    }

    ImmutableList<EditorAttribute> toEditorAttributes(Iterable<Attribute> attributes) {
        return ImmutableList.copyOf(StreamSupport.stream(attributes.spliterator(), false).map(this::toEditorAttribute).iterator());
    }

    private EditorAttribute toEditorAttribute(Attribute attribute) {
        String id = attribute.getIdentifier();
        String name = attribute.getName();
        String type = attribute.getDataType() != null ? AttributeType.getValueString((AttributeType)attribute.getDataType()) : null;
        EditorAttributeIdentifier parent = this.attributeReferenceMapper.toEditorAttributeIdentifier(attribute.getParent());
        EditorEntityTypeIdentifier refEntityType = this.entityTypeReferenceMapper.toEditorEntityTypeIdentifier(attribute.getRefEntity());
        EditorAttributeIdentifier mappedByEntityType = this.attributeReferenceMapper.toEditorAttributeIdentifier(attribute.getMappedBy());
        EditorSort orderBy = this.sortMapper.toEditorSort(attribute.getOrderBy());
        String expression = attribute.getExpression();
        boolean nullable = attribute.isNillable();
        boolean auto = attribute.isAuto();
        boolean visible = attribute.isVisible();
        String label = attribute.getLabel();
        ImmutableMap<String, String> i18nLabel = this.toI18nLabel(attribute);
        String description = attribute.getDescription();
        ImmutableMap<String, String> i18nDescription = this.toI18nDescription(attribute);
        boolean aggregatable = attribute.isAggregatable();
        ImmutableList enumOptions = ImmutableList.copyOf((Collection)attribute.getEnumOptions());
        Long rangeMin = attribute.getRangeMin();
        Long rangeMax = attribute.getRangeMax();
        boolean readonly = attribute.isReadOnly();
        boolean unique = attribute.isUnique();
        ImmutableList<EditorTagIdentifier> tags = this.tagMapper.toEditorTags(attribute.getTags());
        String nullableExpression = attribute.getNullableExpression();
        String visibleExpression = attribute.getVisibleExpression();
        String validationExpression = attribute.getValidationExpression();
        String defaultValue = attribute.getDefaultValue();
        Integer sequenceNumber = attribute.getSequenceNumber() != null ? attribute.getSequenceNumber() : 0;
        return EditorAttribute.create(id, name, type, parent, refEntityType, mappedByEntityType, orderBy, expression, nullable, auto, visible, label, i18nLabel, description, i18nDescription, aggregatable, (List<String>)enumOptions, rangeMin, rangeMax, readonly, unique, tags, nullableExpression, visibleExpression, validationExpression, defaultValue, sequenceNumber);
    }

    private ImmutableMap<String, String> toI18nLabel(Attribute attribute) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        LanguageService.getLanguageCodes().forEach(languageCode -> {
            String label = attribute.getString(AttributeUtils.getI18nAttributeName((String)"label", (String)languageCode));
            if (label != null) {
                mapBuilder.put(languageCode, (Object)label);
            }
        });
        return mapBuilder.build();
    }

    private ImmutableMap<String, String> toI18nDescription(Attribute attribute) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        LanguageService.getLanguageCodes().forEach(languageCode -> {
            String description = attribute.getString(AttributeUtils.getI18nAttributeName((String)"description", (String)languageCode));
            if (description != null) {
                mapBuilder.put(languageCode, (Object)description);
            }
        });
        return mapBuilder.build();
    }

    private Attribute toAttribute(int seqNr, EditorAttribute editorAttribute, EditorEntityType editorEntityType) {
        Attribute attribute = this.attributeFactory.create();
        attribute.setIdentifier(editorAttribute.getId());
        attribute.setName(editorAttribute.getName());
        attribute.setEntity(this.entityTypeReferenceMapper.toEntityTypeReference(editorEntityType.getId()));
        attribute.setSequenceNumber(seqNr);
        attribute.setDataType(AttributeType.toEnum((String)editorAttribute.getType()));
        attribute.setIdAttribute(Boolean.valueOf(this.isIdAttribute(editorAttribute, editorEntityType)));
        attribute.setLabelAttribute(Boolean.valueOf(this.isLabelAttribute(editorAttribute, editorEntityType)));
        attribute.setLookupAttributeIndex(this.getLookupAttributeIndex(editorAttribute, editorEntityType));
        EditorEntityTypeIdentifier refEntityType = editorAttribute.getRefEntityType();
        if (refEntityType != null) {
            attribute.setRefEntity(this.entityTypeReferenceMapper.toEntityTypeReference(refEntityType.getId()));
        }
        attribute.setMappedBy(this.attributeReferenceMapper.toAttributeReference(editorAttribute.getMappedByAttribute()));
        attribute.setOrderBy(this.sortMapper.toSort(editorAttribute.getOrderBy()));
        attribute.setExpression(editorAttribute.getExpression());
        attribute.setNillable(editorAttribute.isNullable());
        attribute.setAuto(editorAttribute.isAuto());
        attribute.setVisible(editorAttribute.isVisible());
        attribute.setLabel(editorAttribute.getLabel());
        if (editorAttribute.getLabelI18n() != null) {
            LanguageService.getLanguageCodes().forEach(languageCode -> attribute.setLabel(languageCode, editorAttribute.getLabelI18n().get(languageCode)));
        }
        attribute.setDescription(editorAttribute.getDescription());
        if (editorAttribute.getDescriptionI18n() != null) {
            LanguageService.getLanguageCodes().forEach(languageCode -> attribute.setDescription(languageCode, editorAttribute.getDescriptionI18n().get(languageCode)));
        }
        attribute.setAggregatable(editorAttribute.isAggregatable());
        attribute.setEnumOptions(editorAttribute.getEnumOptions());
        attribute.setRangeMin(editorAttribute.getRangeMin());
        attribute.setRangeMax(editorAttribute.getRangeMax());
        attribute.setReadOnly(editorAttribute.isReadonly());
        attribute.setUnique(editorAttribute.isUnique());
        attribute.setTags(this.tagMapper.toTagReferences(editorAttribute.getTags()));
        attribute.setVisibleExpression(editorAttribute.getVisibleExpression());
        attribute.setValidationExpression(editorAttribute.getValidationExpression());
        attribute.setDefaultValue(editorAttribute.getDefaultValue());
        return attribute;
    }

    private Integer getLookupAttributeIndex(EditorAttribute editorAttribute, EditorEntityType editorEntityType) {
        EditorAttributeIdentifier editorAttributeIdentifier = EditorAttributeIdentifier.create(editorAttribute.getId(), editorAttribute.getLabel());
        int index = editorEntityType.getLookupAttributes().indexOf(editorAttributeIdentifier);
        return index != -1 ? Integer.valueOf(index) : null;
    }

    private boolean isIdAttribute(EditorAttribute editorAttribute, EditorEntityType editorEntityType) {
        return editorEntityType.getIdAttribute() != null && editorEntityType.getIdAttribute().getId().equals(editorAttribute.getId());
    }

    private boolean isLabelAttribute(EditorAttribute editorAttribute, EditorEntityType editorEntityType) {
        return editorEntityType.getLabelAttribute() != null && editorEntityType.getLabelAttribute().getId().equals(editorAttribute.getId());
    }
}

