/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.mapper;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.support.LazyEntity;
import org.molgenis.metadata.manager.model.EditorEntityTypeIdentifier;
import org.springframework.stereotype.Component;

@Component
class EntityTypeReferenceMapper {
    private final EntityTypeMetadata entityTypeMetadata;
    private final DataService dataService;

    EntityTypeReferenceMapper(EntityTypeMetadata entityTypeMetadata, DataService dataService) {
        this.entityTypeMetadata = Objects.requireNonNull(entityTypeMetadata);
        this.dataService = Objects.requireNonNull(dataService);
    }

    EntityType toEntityTypeReference(String entityTypeId) {
        if (entityTypeId == null) {
            return null;
        }
        return new EntityType((Entity)new LazyEntity((EntityType)this.entityTypeMetadata, this.dataService, (Object)entityTypeId));
    }

    ImmutableList<EditorEntityTypeIdentifier> toEditorEntityTypeIdentifiers(Iterable<EntityType> extendedBy) {
        return ImmutableList.copyOf(StreamSupport.stream(extendedBy.spliterator(), false).map(this::toEditorEntityTypeIdentifier).iterator());
    }

    EditorEntityTypeIdentifier toEditorEntityTypeIdentifier(EntityType entityType) {
        if (entityType == null) {
            return null;
        }
        String id = entityType.getId();
        String label = entityType.getLabel();
        return EditorEntityTypeIdentifier.create(id, label);
    }
}

