/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.metadata.manager.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.UnknownEntityTypeException;
import org.molgenis.data.meta.MetaDataService;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.util.EntityTypeUtils;
import org.molgenis.i18n.LanguageService;
import org.molgenis.metadata.manager.mapper.AttributeMapper;
import org.molgenis.metadata.manager.mapper.EntityTypeMapper;
import org.molgenis.metadata.manager.mapper.PackageMapper;
import org.molgenis.metadata.manager.model.EditorAttribute;
import org.molgenis.metadata.manager.model.EditorAttributeResponse;
import org.molgenis.metadata.manager.model.EditorEntityType;
import org.molgenis.metadata.manager.model.EditorEntityTypeResponse;
import org.molgenis.metadata.manager.model.EditorPackageIdentifier;
import org.molgenis.metadata.manager.service.MetadataManagerService;
import org.springframework.stereotype.Component;

@Component
public class MetadataManagerServiceImpl
implements MetadataManagerService {
    private final MetaDataService metadataService;
    private final PackageMapper packageMapper;
    private final EntityTypeMapper entityTypeMapper;
    private final AttributeMapper attributeMapper;

    public MetadataManagerServiceImpl(MetaDataService metadataService, PackageMapper packageMapper, EntityTypeMapper entityTypeMapper, AttributeMapper attributeMapper) {
        this.metadataService = Objects.requireNonNull(metadataService);
        this.packageMapper = Objects.requireNonNull(packageMapper);
        this.entityTypeMapper = Objects.requireNonNull(entityTypeMapper);
        this.attributeMapper = Objects.requireNonNull(attributeMapper);
    }

    @Override
    public List<EditorPackageIdentifier> getEditorPackages() {
        return this.createPackageListResponse(this.metadataService.getPackages());
    }

    @Override
    public EditorEntityTypeResponse getEditorEntityType(String entityTypeId) {
        EntityType entityType = this.metadataService.getEntityType(entityTypeId);
        if (entityType == null) {
            throw new UnknownEntityTypeException(entityTypeId);
        }
        return this.createEntityTypeResponse(entityType, this.metadataService.getReferringAttributes(entityTypeId).filter(EntityTypeUtils::isSingleReferenceType).collect(Collectors.toList()));
    }

    @Override
    public EditorEntityTypeResponse createEditorEntityType() {
        return this.createEntityTypeResponse();
    }

    @Override
    public void upsertEntityType(EditorEntityType editorEntityType) {
        EntityType entityType = this.entityTypeMapper.toEntityType(editorEntityType);
        this.metadataService.upsertEntityTypes((Collection)Lists.newArrayList((Object[])new EntityType[]{entityType}));
    }

    @Override
    public EditorAttributeResponse createEditorAttribute() {
        return this.createAttributeResponse();
    }

    private List<EditorPackageIdentifier> createPackageListResponse(List<Package> packages) {
        ArrayList response = Lists.newArrayList();
        for (Package package_ : packages) {
            response.add(this.packageMapper.toEditorPackage(package_));
        }
        return response;
    }

    private EditorEntityTypeResponse createEntityTypeResponse() {
        EditorEntityType editorEntityType = this.entityTypeMapper.createEditorEntityType();
        return this.createEntityTypeResponse(editorEntityType);
    }

    private EditorEntityTypeResponse createEntityTypeResponse(EntityType entityType, List<Attribute> referringAttributes) {
        EditorEntityType editorEntityType = this.entityTypeMapper.toEditorEntityType(entityType, referringAttributes);
        return this.createEntityTypeResponse(editorEntityType);
    }

    private EditorEntityTypeResponse createEntityTypeResponse(EditorEntityType editorEntityType) {
        ImmutableList languageCodes = ImmutableList.copyOf(LanguageService.getLanguageCodes().iterator());
        return EditorEntityTypeResponse.create(editorEntityType, (List<String>)languageCodes);
    }

    private EditorAttributeResponse createAttributeResponse() {
        EditorAttribute editorAttribute = this.attributeMapper.createEditorAttribute();
        return this.createAttributeResponse(editorAttribute);
    }

    private EditorAttributeResponse createAttributeResponse(EditorAttribute editorAttribute) {
        ImmutableList languageCodes = ImmutableList.copyOf(LanguageService.getLanguageCodes().iterator());
        return EditorAttributeResponse.create(editorAttribute, (List<String>)languageCodes);
    }
}

